#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_BloodUnitTest : BaseTest 
	{

		private BOL.BloodUnitTest _tstBUT;
		//private DataTable _dtBloodUnitTest;
		
		private Guid _confirmationWorklistGuid;

		private DataTable _dtBloodUnit;
		private DataTable _dtBloodUnitTest;
		private DataTable _dtSpecialUnitTest;
		private DataTable _dtRack;
		private DataTable _dtReagent;
		private DataTable _dtRackLot;
		private DataTable _dtRackTest;
		private DataTable _dtAntiseraWorklistTyping;
		private DataTable _dtBUTwOrderedTest;
		private DataTable _dtBUTwOrderedComponent;
		private DataTable _dtOrderedUnit;
		private DataTable _dtOrderedTest;
		private DataTable _dtOrderedComponent;

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				//***Get the Rack data
				this._dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Rack WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'" , false);
				if (this._dtRack.Rows.Count == 0)
				{
					DataCreator.CreateQCdRack();
					this._dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Rack WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'" , false);
				}

				this._dtBloodUnitTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitTest WHERE TestDate IS NOT NULL AND RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'", false);
				if (this._dtBloodUnitTest.Rows.Count == 0)
				{
					BOL.BloodUnit tmpUnit = DataCreator.CreateRBCBloodUnit(true);
					DataCreator.CreateAboRhConfirmationTestsForUnit(tmpUnit.BloodUnitGuid, tmpUnit.BloodUnitMedia.AboRh);
					this._dtBloodUnitTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitTest WHERE TestDate IS NOT NULL AND RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'", true);
				}
				DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitTest WHERE ConfirmationWorklistUnitGuid IS NOT NULL AND DivisionCode = '" + this.TestDivisionCode + "'", false);
				if (dtTemp.Rows.Count == 0)
				{
					BOL.BloodUnit tmpUnitConfirm = DataCreator.CreateRBCBloodUnit(true);
					DataCreator.CreateAboRhConfirmationTestsForUnit(tmpUnitConfirm.BloodUnitGuid, tmpUnitConfirm.BloodUnitMedia.AboRh);
					dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitTest WHERE ConfirmationWorklistUnitGuid IS NOT NULL AND DivisionCode = '" + this.TestDivisionCode + "'", true);
				}

				this._confirmationWorklistGuid = (Guid)dtTemp.Rows[0][TABLES.BloodUnitTest.ConfirmationWorklistUnitGuid];

				this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'", true);

				//***Get BloodUnitTest data  -- With ABO to handle most calls
				this._dtBloodUnitTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitTest WHERE BloodTestTypeId > 14 AND BloodTestTypeId < 22 AND ConfirmationWorklistUnitGuid IS NOT NULL AND RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'", true);

				//***Get the SpecialUnitTest data
				string sql = "SELECT TOP 1 * FROM dbo.BloodUnitTest BUT INNER JOIN   dbo.BloodTestType BTT on BUT.BloodTestTypeID = BUT.BloodTestTypeID INNER JOIN dbo.BloodUnitAntigen BUA on BUA.BloodUnitGUID = BUT.BloodUnitGUID INNER JOIN dbo.AntigenType ATT on ATT.AntigenTypeID = BUA.AntigenTypeID WHERE BUT.DivisionCode = '" + this.TestDivisionCode + "' AND BUT.RecordStatusCode = 'A'";
				this._dtSpecialUnitTest = UnitTestUtil.RunSQLGetDataTable(sql, false);
				if (this._dtSpecialUnitTest.Rows.Count == 0)
				{
					Guid unitGuid = Guid.NewGuid();
					BOL.BloodUnit tmpUnit = DataCreator.CreateBloodUnit(unitGuid, Guid.NewGuid(), Guid.Empty, DataCreator.GetRandomBloodProduct(true, COMMON.ComponentClass.RBC).BloodProductGuid, true);
					DataCreator.CreateAboRhConfirmationTestsForUnit(unitGuid, tmpUnit.BloodUnitMedia.AboRh);
					DataTable dtBUA = SprocHelper.GetInsertBloodUnitAntigenSprocTable(unitGuid);
					new Common.StoredProcedure().TransactionalGetValue(SPROCS.InsertBloodUnitAntigen.StoredProcName, dtBUA);
					this._dtSpecialUnitTest = UnitTestUtil.RunSQLGetDataTable(sql, true);
				}

				//***Get the Reagent data
				this._dtReagent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Reagent WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'" , false);
				if (this._dtReagent.Rows.Count == 0)
				{
					DataCreator.CreateQCdRack();
					this._dtReagent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Reagent WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'" , true);
				}

				//***Get the RackLot data
				this._dtRackLot = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM RackLot WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'" , false);
				if (this._dtReagent.Rows.Count == 0)
				{
					DataCreator.CreateQCdRack();
					this._dtRackLot = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM RackLot WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'" , true);
				}

				//***Get the RackTest data
				this._dtRackTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM RackTest WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'" , false);
				if (this._dtReagent.Rows.Count == 0)
				{
					DataCreator.CreateQCdRack();
					this._dtRackTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM RackTest WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'" , true);
				}

				//***Get the AntiseraWorklistTyping data
				this._dtAntiseraWorklistTyping = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 BUT.*, AWT.AntiseraWorklistGuid, AWT.OrderableTestId FROM BloodUnitTest BUT JOIN AntiseraWorklistTyping AWT ON AWT.AntiseraWorklistTypingGuid = BUT.AntiseraWorklistTypingGuid WHERE BUT.DivisionCode = '" + this.TestDivisionCode + "' AND BUT.RecordStatusCode = 'A'" , false);
				if (this._dtAntiseraWorklistTyping.Rows.Count == 0)
				{
					new BOL.UnitTests.BOL_AntiseraWorklist().Save_Pass_AntigenTyping();
					this._dtAntiseraWorklistTyping = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 BUT.*, AWT.AntiseraWorklistGuid, AWT.OrderableTestId FROM BloodUnitTest BUT JOIN AntiseraWorklistTyping AWT ON AWT.AntiseraWorklistTypingGuid = BUT.AntiseraWorklistTypingGuid WHERE BUT.DivisionCode = '" + this.TestDivisionCode + "' AND BUT.RecordStatusCode = 'A'" , true);
				}


				//***Get the BloodUnitTest with an OrderedTestGuid data
				this._dtBUTwOrderedTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitTest JOIN BloodTestType ON BloodTestType.BloodTestTypeID = BloodUnitTest.BloodTestTypeID JOIN OrderedUnit ON OrderedUnit.BloodUnitGuid = BloodUnitTest.BloodUnitGuid AND OrderedUnit.ReleaseDate IS NULL AND OrderedUnit.OrderedTestGuid IS NOT NULL WHERE BloodUnitTest.OrderedTestGuid IS NOT NULL AND BloodUnitTest.RecordStatusCode = 'A' AND BloodUnitTest.DivisionCode = '" + this.TestDivisionCode + "'", false);
				if (this._dtBUTwOrderedTest.Rows.Count == 0)
				{
					Guid buGuid = Guid.NewGuid();
					DataCreator.CreateBloodUnit(buGuid, Guid.NewGuid(), Guid.Empty, DataCreator.GetRandomBloodProduct(true, COMMON.ComponentClass.RBC).BloodProductGuid, true);

					DataCreator.CreatePatientAssignment(buGuid , Guid.NewGuid(), true,false );
					this._dtBUTwOrderedTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitTest JOIN BloodTestType ON BloodTestType.BloodTestTypeID = BloodUnitTest.BloodTestTypeID JOIN OrderedUnit ON OrderedUnit.BloodUnitGuid = BloodUnitTest.BloodUnitGuid AND OrderedUnit.ReleaseDate IS NULL AND OrderedUnit.OrderedTestGuid IS NOT NULL WHERE BloodUnitTest.OrderedTestGuid IS NOT NULL AND BloodUnitTest.RecordStatusCode = 'A' AND BloodUnitTest.DivisionCode = '" + this.TestDivisionCode + "'", true);
				}

				//***Get the BloodUnitTest with an OrderedComponentGuid data
				this._dtBUTwOrderedComponent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitTest WHERE OrderedComponentGuid IS NOT NULL AND RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'", true);

				//***Get the OrderedUnit info for InvalidateCrossMatchStatus
				this._dtOrderedUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedUnit WHERE DivisionCode = '" + this.TestDivisionCode + "'", true);

				//***Get the OrderedTest info for InvalidateCrossMatchStatus
				this._dtOrderedTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedTest WHERE DivisionCode = '" + this.TestDivisionCode + "'", true);

				//***Get the OrderedComponent info for InvalidateCrossMatchStatus
				this._dtOrderedComponent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedComponent WHERE DivisionCode = '" + this.TestDivisionCode + "'", true);

				this.RefreshData = false;
			}

			this._tstBUT = new BOL.BloodUnitTest(this._dtBloodUnitTest.Rows[0]);

		}



		[Test]
		public void Ctor_Guid_Int_Pass()
		{
			Guid unitGuid = (Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitGuid];
			int testId = Convert.ToInt32(this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodTestTypeId]);

			BOL.BloodUnitTest tmpBUT = new BOL.BloodUnitTest(unitGuid, testId);

			Assert.IsNotNull(tmpBUT);
			Assert.AreEqual(tmpBUT.BloodUnitGuid, unitGuid);
			Assert.AreEqual(tmpBUT.BloodTestTypeObj.BloodTestTypeId, testId);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Guid_Int_Fail()
		{
		}

		[Test]
		public void Ctor_Guid_Guid_Int_DateTime_String_String_String_String_Pass()
		{
			Guid testGuid = Guid.NewGuid();
			Guid unitGuid = (Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitGuid];
			int testId = (int)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodTestTypeId];
			DateTime testDate = DateTime.Now;
			string testResult = "ABC";
			string testComments = "DEF";
			string entryMethod = "M";

			BOL.BloodUnitTest tmpBUT = new BOL.BloodUnitTest(testGuid, unitGuid, testId, testDate, testResult, testComments, entryMethod, this.TestDivisionCode);

			Assert.IsNotNull(tmpBUT);
			Assert.AreEqual(tmpBUT.BloodUnitGuid, unitGuid);
			Assert.AreEqual(tmpBUT.BloodUnitTestGuid, testGuid);
			Assert.AreEqual(tmpBUT.TestDate, testDate);
			Assert.AreEqual(tmpBUT.TestResultId, testResult);
			Assert.AreEqual(tmpBUT.TestComments, testComments);
			Assert.AreEqual(tmpBUT.EntryMethodCode, entryMethod);
			Assert.AreEqual(tmpBUT.BloodTestTypeObj.BloodTestTypeId, testId);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Guid_Guid_Int_DateTime_String_String_String_String_Fail()
		{
		}

		
		[Test]
		public void Ctor_DataRow_Pass()
		{
			Guid testGuid = (Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitTestGuid];
			Guid unitGuid = (Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitGuid];
			int testId = (int)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodTestTypeId];
			DateTime testDate = (DateTime)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.TestDate];

			BOL.BloodUnitTest tmpBUT = new BOL.BloodUnitTest(this._dtBloodUnitTest.Rows[0]);

			Assert.IsNotNull(tmpBUT);
			Assert.AreEqual(tmpBUT.BloodUnitGuid, unitGuid);
			Assert.AreEqual(tmpBUT.BloodUnitTestGuid, testGuid);
			Assert.AreEqual(tmpBUT.TestDate, testDate);
			Assert.AreEqual(tmpBUT.BloodTestTypeObj.BloodTestTypeId, testId);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_DataRow_Fail()
		{
		}


		[Test]
		public void BloodUnitGuid_Pass()
		{
			Guid tstValue = Guid.NewGuid();
			
			this._tstBUT.BloodUnitGuid = tstValue;

			Assert.AreEqual(this._tstBUT.BloodUnitGuid, tstValue);
		}


		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BloodUnitGuid_Fail()
		{
		}

		[Test]
		public void EntryMethodCode_Pass()
		{
			string tstValue = DateTime.Now.ToString();
			
			this._tstBUT.EntryMethodCode = tstValue;

			Assert.AreEqual(this._tstBUT.EntryMethodCode, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void EntryMethodCode_Fail()
		{
		}

		[Test]
		public void AntiseraWorklistTypingGuid_Pass()
		{
			Guid tstValue = Guid.NewGuid();
			
			this._tstBUT.AntiseraWorklistTypingGuid = tstValue;

			Assert.AreEqual(this._tstBUT.AntiseraWorklistTypingGuid, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AntiseraWorklistTypingGuid_Fail()
		{
		}

		[Test]
		public void ConfirmationWorklistUnitGuid_Pass()
		{
			Guid tstValue = Guid.NewGuid();
			
			this._tstBUT.ConfirmationWorklistUnitGuid = tstValue;

			Assert.AreEqual(this._tstBUT.ConfirmationWorklistUnitGuid, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ConfirmationWorklistUnitGuid_Fail()
		{
		}

		[Test]
		public void OrderableTestId_Pass()
		{
			int tstValue = new Random().Next(99999);
			
			this._tstBUT.OrderableTestId = tstValue;

			Assert.AreEqual(this._tstBUT.OrderableTestId, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderableTestId_Fail()
		{
		}

		[Test]
		public void Reagent_Pass()
		{
			BOL.Reagent tstValue = new BOL.Reagent();
			
			this._tstBUT.Reagent = tstValue;

			Assert.AreEqual(this._tstBUT.Reagent, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Reagent_Fail()
		{
		}

		[Test]
		public void RecordStatusCode_Pass()
		{
			this._tstBUT.RecordStatusCode = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active).ToString();

			Assert.AreEqual(Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active).ToString(), this._tstBUT.RecordStatusCode);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void RecordStatusCode_Fail()
		{
			this._tstBUT.RecordStatusCode = "9";
		}

		[Test]
		public void Specificity_Pass()
		{
			string tstValue = DateTime.Now.ToString();
			
			this._tstBUT.Specificity = tstValue;

			Assert.AreEqual(this._tstBUT.Specificity, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Specificity_Fail()
		{
		}


		[Test]
		public void TestTechId_Pass()
		{
			string tstValue = DateTime.Now.ToString();
			
			this._tstBUT.TestTechId = tstValue;

			Assert.AreEqual(this._tstBUT.TestTechId, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestTechId_Fail()
		{
		}


		[Test]
		public void TestResult_Pass()
		{
			BOL.TestResult tstValue = new BOL.TestResult();
			
			this._tstBUT.TestResult = tstValue;

			Assert.AreEqual(this._tstBUT.TestResult, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestResult_Fail()
		{
		}

		[Test]
		public void TestingMethod_Pass()
		{
			BOL.TestingMethod tstValue = new BOL.TestingMethod("A");
			
			this._tstBUT.TestingMethod = tstValue;

			Assert.AreEqual(this._tstBUT.TestingMethod, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestingMethod_Fail()
		{
		}

		[Test]
		public void BloodUnit_Pass()
		{
			BOL.BloodUnit tstValue = new BOL.BloodUnit((Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitGuid]);
			
			this._tstBUT.BloodUnit = tstValue;

			Assert.AreEqual(this._tstBUT.BloodUnit, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BloodUnit_Fail()
		{
		}

		[Test]
		public void Rack_Pass()
		{
			BOL.Rack tstValue = new BOL.Rack((Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid]);
			
			this._tstBUT.Rack = tstValue;

			Assert.AreEqual(this._tstBUT.Rack, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Rack_Fail()
		{

		}


		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow drTest = this._tstBUT.LoadDataRowFromThis(this._dtBloodUnitTest.NewRow());

			Assert.IsNotNull(drTest);
			Assert.AreEqual((Guid)drTest[TABLES.BloodUnitTest.BloodUnitTestGuid], this._tstBUT.BloodUnitTestGuid);
			Assert.AreEqual((Guid)drTest[TABLES.BloodUnitTest.BloodUnitGuid], this._tstBUT.BloodUnitGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

		[Test]
		public void GetEmptyAboRhConfirmationTable_Pass()
		{
			DataTable dtTest = BOL.BloodUnitTest.GetEmptyAboRhConfirmationTable();

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(23, dtTest.Columns.Count, "Columns.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEmptyAboRhConfirmationTable_Fail()
		{
		}

		[Test]
		public void GetBloodUnitTestResult_Pass()
		{
			Guid unitGuid = (Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitGuid];
			int testId = (int)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodTestTypeId];

			DataTable dtTest = BOL.BloodUnitTest.GetBloodUnitTestResult(unitGuid, testId, this.TestDivisionCode);
			Assert.IsTrue(dtTest.Rows.Count > 0);
		}

		[Test]
		public void GetBloodUnitTestResult_Fail()
		{
			Guid unitGuid = Guid.NewGuid();
			int testId = (int)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodTestTypeId];

			DataTable dtTest = BOL.BloodUnitTest.GetBloodUnitTestResult(unitGuid, testId, this.TestDivisionCode);
			Assert.AreEqual(dtTest.Rows.Count, 0);
		}

		
		[Test]
		public void GetBloodUnitTestResultValue_Pass()
		{
			Guid unitGuid = (Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitGuid];
			int testId = (int)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodTestTypeId];

			string tstValue = BOL.BloodUnitTest.GetBloodUnitTestResultValue(unitGuid, testId, this.TestDivisionCode);
			Assert.AreEqual(tstValue, tstValue);
		}

		[Test]
		public void GetBloodUnitTestResultValue_Fail()
		{
			Guid unitGuid = Guid.NewGuid();
			int testId = (int)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodTestTypeId];

			string tstValue = BOL.BloodUnitTest.GetBloodUnitTestResultValue(unitGuid, testId, this.TestDivisionCode);
			Assert.AreEqual(tstValue, string.Empty);
		}

		
		[Test]
		public void GetBloodUnitSpecialTest_Pass()
		{
			Guid unitGuid = (Guid)this._dtSpecialUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitGuid];

			DataTable dtTest =  BOL.BloodUnitTest.GetBloodUnitSpecialTest(unitGuid);

			Assert.AreEqual(1, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(true,dtTest.Rows[0][0].ToString().Length>0, "SpecialTests");

		}

		[Test]
		public void GetBloodUnitSpecialTest_Fail()
		{
			Guid unitGuid = Guid.NewGuid();

			DataTable dtTest = BOL.BloodUnitTest.GetBloodUnitSpecialTest(unitGuid);
			
			Assert.AreEqual(1, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(DBNull.Value,dtTest.Rows[0][0], "SpecialTests");
		}


		[Test]
		public void GetSickleCellNegativeUnitsForDivision_Pass()
		{
			DataTable dtTest = BOL.BloodUnitTest.GetSickleCellNegativeUnitsForDivision(this.TestDivisionCode);
			if (dtTest.Rows.Count == 0)
			{
				BOL.BloodUnit tmpUnit = DataCreator.CreateBloodUnit(false);
				DataTable dtBUT = SprocHelper.GetInsertBloodUnitTestSprocTable(Guid.NewGuid(), tmpUnit.BloodUnitGuid, 104, "N");
				new Common.StoredProcedure().TransactionalGetValue(SPROCS.InsertBloodUnitTest.StoredProcName, dtBUT);
				dtTest = BOL.BloodUnitTest.GetSickleCellNegativeUnitsForDivision(this.TestDivisionCode);
			}

			Assert.IsTrue(dtTest.Rows.Count > 0);
		}

		[Test]
		public void GetSickleCellNegativeUnitsForDivision_Fail()
		{
			DataTable dtTest = BOL.BloodUnitTest.GetSickleCellNegativeUnitsForDivision("RABBIT");
			Assert.AreEqual(dtTest.Rows.Count, 0);
		}

		[Test]
		public void GetCMVNegativeUnitsForDivision_Pass()
		{
			DataTable dtTest = BOL.BloodUnitTest.GetCmvNegativeUnitsForDivision(this.TestDivisionCode);
			if (dtTest.Rows.Count == 0)
			{
				BOL.BloodUnit tmpUnit = DataCreator.CreateBloodUnit(false);
				DataTable dtBUT = SprocHelper.GetInsertBloodUnitTestSprocTable(Guid.NewGuid(), tmpUnit.BloodUnitGuid, 103, "N");
				new Common.StoredProcedure().TransactionalGetValue(SPROCS.InsertBloodUnitTest.StoredProcName, dtBUT);
				dtTest = BOL.BloodUnitTest.GetCmvNegativeUnitsForDivision(this.TestDivisionCode);
			}
			Assert.IsTrue(dtTest.Rows.Count > 0);
		}

		[Test]
		public void GetCMVNegativeUnitsForDivision_Fail()
		{
			DataTable dtTest = BOL.BloodUnitTest.GetCmvNegativeUnitsForDivision("RABBIT");
			Assert.AreEqual(dtTest.Rows.Count, 0);
		}

		[Test]
		public void GetAboConfirmationLookup_Pass()
		{
			DataTable dtTest = BOL.BloodUnitTest.GetAboConfirmationLookup();
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAboConfirmationLookup_Fail()
		{
		}

		[Test]
		public void GetRHConfirmationLookup_Pass()
		{
			DataTable dtTest = BOL.BloodUnitTest.GetRHConfirmationLookup();
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetRHConfirmationLookup_Fail()
		{
		}

		[Test]
		public void GetAllUnitTestsForDivision_Pass()
		{
			DataTable dtTest = BOL.BloodUnitTest.GetAllUnitTestsForDivision(this.TestDivisionCode);
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		public void GetAllUnitTestsForDivision_Fail()
		{
			DataTable dtTest = BOL.BloodUnitTest.GetAllUnitTestsForDivision("RABBIT");
			Assert.AreEqual(dtTest.Rows.Count, 0);
		}

		[Test]
		public void GetBloodUnitTests_Pass()
		{
			Guid unitGuid = (Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitGuid];

			DataTable dtTest = BOL.BloodUnitTest.GetBloodUnitTests(unitGuid, this.TestDivisionCode);
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		public void GetBloodUnitTests_Fail()
		{
			Guid unitGuid = Guid.NewGuid();

			DataTable dtTest = BOL.BloodUnitTest.GetBloodUnitTests(unitGuid, this.TestDivisionCode);
			Assert.AreEqual(dtTest.Rows.Count, 0);
		}

		[Test]
		public void GetBloodUnitTestsString_Pass()
		{
			Guid unitGuid = (Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitGuid];

			DataTable dtTest = BOL.BloodUnitTest.GetBloodUnitTests(unitGuid.ToString(), this.TestDivisionCode);
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		public void GetBloodUnitTestsString_Fail()
		{
			DataTable dtTest = BOL.BloodUnitTest.GetBloodUnitTests(Guid.Empty.ToString(), this.TestDivisionCode);
			Assert.AreEqual(dtTest.Rows.Count, 0);
		}

		[Test]
		public void GetBloodUnitTestTableSchema_Pass()
		{
			DataTable dtTest1 = BOL.BloodUnitTest.GetBloodUnitTestTableSchema(false);
			
			Assert.AreEqual(14, dtTest1.Columns.Count);
			Assert.AreEqual(dtTest1.TableName, TABLES.BloodUnitTest.TableName);


			DataTable dtTest2 = BOL.BloodUnitTest.GetBloodUnitTestTableSchema(true);
			
			Assert.AreEqual(dtTest2.Columns.Count, 8);
			Assert.AreEqual(dtTest2.TableName, TABLES.BloodUnitTest.TableName);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetBloodUnitTestTableSchema_Fail()
		{
		}

		[Test]
		public void GetBloodUnitTestTableForXM_Pass()
		{
			DataTable dtTest = BOL.BloodUnitTest.GetBloodUnitTestTableForXM(false);
			
			Assert.AreEqual(19, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(TABLES.BloodUnitTest.TableName+"Insert", dtTest.TableName, "TableName" );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetBloodUnitTestTableForXM_Fail()
		{
		}

		[Test]
		public void GetAboRHConfirmationTests_Pass()
		{
			Guid unitGuid = (Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitGuid];

			ArrayList alTest = BOL.BloodUnitTest.GetAboRHConfirmationTests(unitGuid, this.TestDivisionCode);
			Assert.IsTrue(alTest.Count >= 0);
		}

		[Test]
		public void GetAboRHConfirmationTests_Fail()
		{
			Guid unitGuid = Guid.NewGuid();

			ArrayList alTest = BOL.BloodUnitTest.GetAboRHConfirmationTests(unitGuid, this.TestDivisionCode);
			Assert.AreEqual(alTest.Count , 0);
		}

		[Test]
		public void GetAntigenTypingTests_Pass()
		{
			Guid unitGuid = (Guid)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodUnitGuid];

			ArrayList alTest = BOL.BloodUnitTest.GetAntigenTypingTests(unitGuid, this.TestDivisionCode);
			Assert.IsTrue(alTest.Count >= 0);
		}

		[Test]
		public void GetAntigenTypingTests_Fail()
		{
			Guid unitGuid = Guid.NewGuid();

			ArrayList alTest = BOL.BloodUnitTest.GetAntigenTypingTests(unitGuid, this.TestDivisionCode);
			Assert.AreEqual(alTest.Count , 0);
		}

		[Test]
		public void UpdateTestResult_Pass()
		{
			this.RefreshData = true;

			this._tstBUT.TestResult = new BOL.TestResult("1");
			this._tstBUT.TestResultId = "1";
			this._tstBUT.TestDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime(this.TestDivisionCode);

			this._tstBUT.UpdateTestResult(Common.UpdateFunction.UnitTests);

			//No return code to check - what a letdown :(
			Assert.IsTrue(true);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(Common.RowVersionException))]
		public void UpdateTestResult_Fail()
		{
			this.RefreshData = true;

			this._tstBUT.TestDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime(this.TestDivisionCode);
			this._tstBUT.RowVersion = new byte[8];

			this._tstBUT.UpdateTestResult(Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void SaveBloodUnitTest_Pass()
		{
			Guid unitGuid = (Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			int testTypeId = (int)Common.TestType.AntiA;

			BOL.BloodUnitTest tmpBUT = new BOL.BloodUnitTest(unitGuid, testTypeId);

			tmpBUT.TestResultId = Common.TestResult.A.ToString();
			tmpBUT.EntryMethodCode = "M";
			tmpBUT.TestComments = "SaveBloodUnitTest_Pass()";

			tmpBUT.SaveBloodUnitTest(this._confirmationWorklistGuid, Common.UpdateFunction.UnitTests);
			
			Assert.IsTrue(true);		//no return code!  WOO HOO!
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(Common.DataAccessLayerException))]
		public void SaveBloodUnitTest_Fail()
		{
			this.RefreshData = true;

			int testId = (int)this._dtBloodUnitTest.Rows[0][TABLES.BloodUnitTest.BloodTestTypeId];

			BOL.BloodUnitTest tmpBUT = new BOL.BloodUnitTest(Guid.NewGuid(), testId);

			tmpBUT.SaveBloodUnitTest(this._confirmationWorklistGuid, Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void SaveAboRhBloodUnitTests_Pass()
		{
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.ABOForwardTypingUnit);
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.ABORhForwardTypingUnit);

            Common.WorkloadProcessID workloadProcessId = Common.WorkloadProcessID.ABOForwardTypingUnit;     //POS below


			Guid rackGuid = DataCreator.GetRecordGuid("SELECT TOP 1 RackGuid FROM Rack WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");			
			//Gotta update the DailyQcWorklist for Rack constructor
			UnitTestUtil.RunSQL("UPDATE DailyQcWorklist SET DailyQcExpirationDate = GETUTCDATE() WHERE RecordStatusCode = 'A' AND RackGuid = '" + rackGuid.ToString() + "'");

			BOL.BloodUnit tmpBU = new BOL.BloodUnit((Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid]);
			
			DataTable dtAboRh = BOL.BloodUnitTest.GetEmptyAboRhConfirmationTable();
			DataRow drData = dtAboRh.NewRow();

			drData[ARTIFICIAL.Indicator] = "V";
			drData[TABLES.BloodUnit.EyeReadableUnitId] = tmpBU.EyeReadableUnitId;
			drData[TABLES.ValidAboResult.AntiA] = "P";
			drData[TABLES.ValidAboResult.AntiB] = "N";
			drData[TABLES.ValidAboResult.AntiAB] = "P";
			drData[TABLES.ValidRhResult.AntiD] = "X";
			drData[TABLES.ValidRhResult.DControl] = "X";
			drData[TABLES.ValidAboResult.AboInterp] = "A";
			drData[TABLES.ValidRhResult.RhInterp] = "X";
			drData[ARTIFICIAL.AboComment] = "SaveAboRhBloodUnitTests_Pass()";
			drData[ARTIFICIAL.RhComment] = "SaveAboRhBloodUnitTests_Pass()";
			drData[TABLES.BloodUnit.BloodUnitGuid] = tmpBU.BloodUnitGuid;
			drData[TABLES.BloodUnitStatus.RowVersion] = tmpBU.BloodUnitStatus.RowVersion;
			drData[TABLES.BloodUnitStatus.BloodUnitStatusGuid] = tmpBU.BloodUnitStatus.BloodUnitStatusGuid;

			dtAboRh.Rows.Add(drData);			
																																													
			BOL.BloodUnitTest.SaveAboRHBloodUnitTests(dtAboRh, DateTime.Now, Common.LogonUser.LogonUserName, "UnitTest", true, rackGuid, Common.UpdateFunction.UnitTests, workloadProcessId, string.Empty);

			Assert.IsTrue(true);		//No return value to check, so no crash = Success!

		}

		[Test]
        [ExpectedException(typeof(Common.RowVersionException))]
		public void SaveAboRhBloodUnitTests_Fail()
		{
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.ABOForwardTypingUnit);
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.ABORhForwardTypingUnit);

            Common.WorkloadProcessID workloadProcessId = Common.WorkloadProcessID.ABOForwardTypingUnit; //POS below

			Guid rackGuid = DataCreator.GetRecordGuid("SELECT TOP 1 RackGuid FROM Rack WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");			
			//Gotta update the DailyQcWorklist for Rack constructor
			UnitTestUtil.RunSQL("UPDATE DailyQcWorklist SET DailyQcExpirationDate = GETUTCDATE() WHERE RecordStatusCode = 'A' AND RackGuid = '" + rackGuid.ToString() + "'");

			BOL.BloodUnit tmpBU = new BOL.BloodUnit((Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid]);
			DataTable dtAboRh = BOL.BloodUnitTest.GetEmptyAboRhConfirmationTable();
			DataRow drData = dtAboRh.NewRow();

			drData[ARTIFICIAL.Indicator] = "V";
			drData[TABLES.BloodUnit.EyeReadableUnitId] = tmpBU.EyeReadableUnitId;
			drData[TABLES.ValidAboResult.AntiA] = "P";
			drData[TABLES.ValidAboResult.AntiB] = "N";
			drData[TABLES.ValidAboResult.AntiAB] = "P";
			drData[TABLES.ValidRhResult.AntiD] = "X";
			drData[TABLES.ValidRhResult.DControl] = "X";
			drData[TABLES.ValidAboResult.AboInterp] = "A";
			drData[TABLES.ValidRhResult.RhInterp] = "X";
			drData[ARTIFICIAL.AboComment] = "SaveAboRhBloodUnitTests_Pass()";
			drData[ARTIFICIAL.RhComment] = "SaveAboRhBloodUnitTests_Pass()";
            drData[TABLES.BloodUnit.BloodUnitGuid] = tmpBU.BloodUnitGuid;
			drData[TABLES.BloodUnitStatus.RowVersion] = new byte[8];    //RowVersion failure on update
            drData[TABLES.BloodUnitStatus.BloodUnitStatusGuid] = tmpBU.BloodUnitStatus.BloodUnitStatusGuid;

			dtAboRh.Rows.Add(drData);			

			BOL.BloodUnitTest.SaveAboRHBloodUnitTests(dtAboRh, DateTime.Now, Common.LogonUser.LogonUserName, "UnitTest", true, rackGuid, Common.UpdateFunction.UnitTests, workloadProcessId, string.Empty);
		}

		[Test]
		public void SaveAntigenTypingBloodUnitTests_AHGCC_Pass()
		{
			//
			//For 100% coverage, we must issue a unit first!
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}
			//
			Guid bloodUnitGuid = Guid.NewGuid();
			//
			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			Guid bloodProductGuid = (Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);
			DataTable dtUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE BloodunitGuid = '"+ bloodUnitGuid.ToString()+"'");
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedComponentGuid = Guid.NewGuid();
			string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
			insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
			insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
			insertOrderedComponent += "VALUES (";
			insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedComponent += "'1',";
            insertOrderedComponent += "'" + SprocHelper.GetNewCprsOrderNumber() + "',";
			insertOrderedComponent += "'2',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'I',";
			insertOrderedComponent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'" + Environment.UserName + "',";
			insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedUnitGuid = Guid.NewGuid();
			string insertOrderedUnit = "INSERT INTO ORDEREDUNIT (";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedComponentGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.BloodUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchRequiredIndicator + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchResultCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchTechId + ",";
			insertOrderedUnit += TABLES.OrderedUnit.RecordStatusCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.DivisionCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateUser + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateFunctionId + ")";
			insertOrderedUnit += "VALUES (";
			insertOrderedUnit += "'" + orderedUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedUnit += "'" + bloodUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "1,";
			insertOrderedUnit += "'C',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'A',";
			insertOrderedUnit += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			string insertBloodUnitTest1 = "INSERT INTO BLOODUNITTEST (";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.BloodUnitTestGuid + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.BloodUnitGuid + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.BloodTestTypeId + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.TestDate + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.TestTechId + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.TestResultId + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.EntryTechId + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.EntryMethodCode + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.OrderedComponentGuid + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.OrderedUnitGuid + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.ReactivityPhaseCode + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.RecordStatusCode + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.DivisionCode + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.LastUpdateDate + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.LastUpdateUser + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.LastUpdateFunctionId + ")";
			insertBloodUnitTest1 += "VALUES (";
			insertBloodUnitTest1 += "'" + bloodUnitTestGuid1.ToString() + "',";
			insertBloodUnitTest1 += "'" + bloodUnitGuid.ToString() + "',";
			insertBloodUnitTest1 += "'100',";
			insertBloodUnitTest1 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest1 += "'" + Environment.UserName + "',";
			insertBloodUnitTest1 += "'0',";
			insertBloodUnitTest1 += "'" + Environment.UserName + "',";
			insertBloodUnitTest1 += "'M',";
			insertBloodUnitTest1 += "'" + orderedComponentGuid.ToString() + "',";
			insertBloodUnitTest1 += "'" + orderedUnitGuid.ToString() + "',";
			insertBloodUnitTest1 += "'2',";
			insertBloodUnitTest1 += "'A',";
			insertBloodUnitTest1 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertBloodUnitTest1 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest1 += "'" + Environment.UserName + "',";
			insertBloodUnitTest1 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			string insertBloodUnitTest2 = "INSERT INTO BLOODUNITTEST (";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.BloodUnitTestGuid + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.BloodUnitGuid + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.BloodTestTypeId + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.TestDate + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.TestTechId + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.TestResultId + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.EntryTechId + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.EntryMethodCode + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.OrderedComponentGuid + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.OrderedUnitGuid + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.ReactivityPhaseCode + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.RecordStatusCode + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.DivisionCode + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.LastUpdateDate + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.LastUpdateUser + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.LastUpdateFunctionId + ")";
			insertBloodUnitTest2 += "VALUES (";
			insertBloodUnitTest2 += "'" + bloodUnitTestGuid2.ToString() + "',";
			insertBloodUnitTest2 += "'" + bloodUnitGuid.ToString() + "',";
			insertBloodUnitTest2 += "'102',";
			insertBloodUnitTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest2 += "'" + Environment.UserName + "',";
			insertBloodUnitTest2 += "'C',";
			insertBloodUnitTest2 += "'" + Environment.UserName + "',";
			insertBloodUnitTest2 += "'M',";
			insertBloodUnitTest2 += "'" + orderedComponentGuid.ToString() + "',";
			insertBloodUnitTest2 += "'" + orderedUnitGuid.ToString() + "',";
			insertBloodUnitTest2 += "'2',";
			insertBloodUnitTest2 += "'A',";
			insertBloodUnitTest2 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertBloodUnitTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest2 += "'" + Environment.UserName + "',";
			insertBloodUnitTest2 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid issuedUnitGuid = Guid.NewGuid();
			string insertIssuedUnit = "INSERT INTO ISSUEDUNIT (";
			insertIssuedUnit += TABLES.IssuedUnit.IssuedUnitGuid + ",";
			insertIssuedUnit += TABLES.IssuedUnit.BloodUnitGuid + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueDateTime + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueTechId + ",";
			insertIssuedUnit += TABLES.IssuedUnit.TransporterName + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueToLocationName + ",";
			insertIssuedUnit += TABLES.IssuedUnit.InPatientLocationIndicator + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueSatisfactoryIndicator + ",";
			insertIssuedUnit += TABLES.IssuedUnit.RemoteStorageIndicator + ",";
			insertIssuedUnit += TABLES.IssuedUnit.LastUpdateDate + ",";
			insertIssuedUnit += TABLES.IssuedUnit.LastUpdateUser + ",";
			insertIssuedUnit += TABLES.IssuedUnit.LastUpdateFunctionId + ")";
			insertIssuedUnit += "VALUES (";
			insertIssuedUnit += "'" + issuedUnitGuid.ToString() + "',";
			insertIssuedUnit += "'" + bloodUnitGuid.ToString() + "',";
			insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertIssuedUnit += "'" + Environment.UserName + "',";
			insertIssuedUnit += "'" + Environment.UserName + "',";
			insertIssuedUnit += "'10W P-KC',";
			insertIssuedUnit += "0,";
			insertIssuedUnit += "1,";
			insertIssuedUnit += "0,";
			insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertIssuedUnit += "'" + Environment.UserName + "',";
			insertIssuedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

//			string updateBloodUnitStatus = "UPDATE BloodUnitStatus SET ";
//			updateBloodUnitStatus += TABLES.BloodUnitStatus.UnitStatusCode + " = '" + Common.Utility.GetUnitStatusCodeCharFromEnum(Common.UnitStatusCode.Issued).ToString() + "' ";
//			updateBloodUnitStatus += "WHERE " + TABLES.BloodUnit.BloodUnitGuid + " = '" + bloodUnitGuid.ToString() + "'";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedComponent);
			UnitTestUtil.RunSQL(insertOrderedUnit);
			UnitTestUtil.RunSQL(insertBloodUnitTest1);
			UnitTestUtil.RunSQL(insertBloodUnitTest2);
			UnitTestUtil.RunSQL(insertIssuedUnit);
//			UnitTestUtil.RunSQL(updateBloodUnitStatus);
			//
			//OK! Now create new Anti-C reagent to test against.
			DataTable dtReagents = Reagent.InitializeReagentsAndManufacturersTable();
			DataRow drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = Guid.NewGuid();
			drReagent[TABLES.ReagentType.ReagentTypeId] = 6; //Anti-C
			drReagent["ReagentName"] = "Test C Reagent";
			drReagent["ReceiptDate"] = DateTime.Now;
			drReagent["ReceiptTechId"] = UnitTestConfig.User_Technologist;
			drReagent["InvoiceNumber"] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "C"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent["NumberVialsReceived"] = 20;
			drReagent["NumberVialsAvailable"] = 15;
			drReagent["Comments"] = "Unit Test 1705";
			drReagent["InspectionIndicator"] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent["ReagentTypeName"] = "Anti-C";
			drReagent[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drReagent["RecordStatusCode"] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Create new Screening Cells reagent to for Pos control.
			drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = Guid.NewGuid();
			drReagent[TABLES.ReagentType.ReagentTypeId] = 63; //Screening Cells
			drReagent["ReagentName"] = "Test SC Reagent";
			drReagent["ReceiptDate"] = DateTime.Now;
			drReagent["ReceiptTechId"] = UnitTestConfig.User_Technologist;
			drReagent["InvoiceNumber"] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "SC"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent["NumberVialsReceived"] = 20;
			drReagent["NumberVialsAvailable"] = 15;
			drReagent["Comments"] = "Unit Test 1705";
			drReagent["InspectionIndicator"] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent["ReagentTypeName"] = "Screening Cells";
			drReagent[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drReagent["RecordStatusCode"] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Create new Check Cells reagent to for Neg control.
			drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = Guid.NewGuid();
			drReagent[TABLES.ReagentType.ReagentTypeId] = 56; //Check Cells
			drReagent["ReagentName"] = "Test CC Reagent";
			drReagent["ReceiptDate"] = DateTime.Now;
			drReagent["ReceiptTechId"] = UnitTestConfig.User_Technologist;
			drReagent["InvoiceNumber"] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = ARTIFICIAL.CC+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent["NumberVialsReceived"] = 20;
			drReagent["NumberVialsAvailable"] = 15;
			drReagent["Comments"] = "Unit Test 1705";
			drReagent["InspectionIndicator"] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent["ReagentTypeName"] = "Check Cells";
			drReagent[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drReagent["RecordStatusCode"] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Insert new reagents
			BOL.Reagent.InsertNewReagent(dtReagents, BOL.ReagentType.GetReagentTypes(), Common.UpdateFunction.UnitTests);
			//
			Guid buGuid = bloodUnitGuid;
			Guid[] buGuids = new Guid[] {buGuid};
			Guid rackGuid = (Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			//
			//Now we will insert a new antisera worklist
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(Guid.NewGuid());
			tmpAW.TestingMethodCode = Common.TestingMethod.Gel;
			tmpAW.WorklistCreateDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			tmpAW.WorklistName = Environment.UserName;
			//
			DataTable tmpAWT = new DataTable();
			tmpAWT.Columns.Add("AntiseraWorklistTypingGuid", typeof(Guid));
			tmpAWT.Columns.Add(TABLES.AntiseraWorklist.AntiseraWorklistGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.ReagentGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.RackGuid,typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.ReactivityPhaseCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.Comments,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.DivisionCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.TestWithId,typeof(int));
			tmpAWT.Columns.Add("RackQCOverrideComment",typeof(string));
			tmpAWT.Columns.Add("ExpiredOverrideComment",typeof(string));
			tmpAWT.Columns.Add("PhaseOverrideComment",typeof(string));
			//
			DataRow drAWT = tmpAWT.NewRow();
			drAWT[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid] = Guid.NewGuid();
			drAWT[TABLES.AntiseraWorklist.AntiseraWorklistGuid] = tmpAW.AntiseraWorklistGuid;
			drAWT[TABLES.OrderableTest.OrderableTestId] = Convert.ToInt32(Common.OrderableTest.AGC).ToString();
			drAWT[TABLES.RackLot.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drAWT[TABLES.RackLot.RackGuid] = rackGuid;
			drAWT[TABLES.RackLot.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.AHGandCC).ToString();
			drAWT[TABLES.RackLot.Comments] = "";
			drAWT[TABLES.RackLot.DivisionCode] = this.TestDivisionCode;
			tmpAWT.Rows.Add(drAWT);
			//
			//Save the antisera worklist
			tmpAW.Save(tmpAWT,dtUnit,Environment.UserName,Common.UpdateFunction.UnitTests,new Guid[] {buGuid}, Guid.Empty, null, false);
			//
			//Now we need to load the saved antisera worklist, complete the tests and save again.
			BOL.AntiseraWorklist aw = new BOL.AntiseraWorklist(tmpAW.AntiseraWorklistGuid);
			DataTable dtAWT = BOL.AntiseraWorklist.GetAntiseraWorklistDetails(tmpAW.AntiseraWorklistGuid);
			DataTable dtUnits = BOL.AntiseraWorklist.GetAntiseraWorklistUnits(tmpAW.AntiseraWorklistGuid);
			//
			DataRow drRackLot = dtAWT.Rows[0];
			DataRow drUnit = dtUnits.Rows[0];
			DataRow drCReagent = dtReagents.Rows[0];
			//
			//Now create AGC grid table
			DataTable dtAGC = new DataTable("Phenotype");
			//
			dtAGC.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtAGC.Columns.Add(TABLES.ExceptionUnitIssue.UnitId, typeof(string));
			dtAGC.Columns.Add(TABLES.BloodProduct.ProductName, typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.IS,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.RT,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.C37,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.AHG,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.Interp, typeof(string));			
			dtAGC.Columns.Add(ARTIFICIAL.Comment, typeof(string));
			dtAGC.Columns.Add(TABLES.ValidRhResult.SystemInterp, typeof(string));
			dtAGC.Columns.Add(TABLES.BloodUnit.BloodUnitGuid, typeof(Guid));
			dtAGC.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dtAGC.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(string));
			dtAGC.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.ISGuid,typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.RTGuid,typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.C37Guid,typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.AHGGuid,typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.InterpGuid, typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.ISRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.RTRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.C37RowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.AHGRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.CCRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.InterpRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.InterpSave, typeof(bool));
			dtAGC.Columns.Add(TABLES.BloodUnitStatus.QuarantineIndicator, typeof(bool));
			dtAGC.Columns.Add(TABLES.VamcDivision.DivisionCode, typeof(string));
			dtAGC.Columns.Add(TABLES.ExceptionQc.ExceptionComment, typeof(string));
			//
			DataRow dr = dtAGC.NewRow();
			dr[ARTIFICIAL.Indicator] = "";
			dr[TABLES.ExceptionUnitIssue.UnitId] = drUnit[TABLES.BloodUnit.EyeReadableUnitId];
			dr[TABLES.BloodProduct.ProductName] = drUnit[TABLES.BloodProduct.ProductShortName];
			dr[ARTIFICIAL.AHG] = "4";
			dr[ARTIFICIAL.CC] = "4";
			dr[ARTIFICIAL.Interp] = "P";
			dr[ARTIFICIAL.Comment] = "Unit Testing";
			dr[TABLES.ValidRhResult.SystemInterp] = "P";
			dr[TABLES.BloodUnit.BloodUnitGuid] = drUnit[TABLES.BloodUnit.BloodUnitGuid];
			dr[TABLES.Reagent.ReagentGuid] = drCReagent[TABLES.Reagent.ReagentGuid];
			dr[TABLES.ReactivityPhase.ReactivityPhaseCode] = drRackLot[TABLES.ReactivityPhase.ReactivityPhaseCode];
			dr[TABLES.OrderableTest.OrderableTestId] = Convert.ToInt32(Common.OrderableTest.AGC);
			dr[ARTIFICIAL.IndicatorMessage] = "";
			dr[ARTIFICIAL.PartiallyCompleted] = false;
			dr[ARTIFICIAL.ISGuid] = Guid.Empty;
			dr[ARTIFICIAL.RTGuid] = Guid.Empty;
			dr[ARTIFICIAL.C37Guid] = Guid.Empty;
			dr[ARTIFICIAL.AHGGuid] = Guid.Empty;
			dr[ARTIFICIAL.CCGuid] = Guid.Empty;
			dr[ARTIFICIAL.InterpGuid] = Guid.Empty;
			dr[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.RTRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			dr[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.ISSave] = false;
			dr[ARTIFICIAL.RTSave] = false;
			dr[ARTIFICIAL.C37Save] = false;
			dr[ARTIFICIAL.AHGSave] = true;
			dr[ARTIFICIAL.CCSave] = true;
			dr[ARTIFICIAL.InterpSave] = true;
			dr[TABLES.BloodUnitStatus.QuarantineIndicator] = true;
			dr[TABLES.ExceptionQc.ExceptionComment] = "Unit Test 1705";
			//
			DataTable results = BOL.AntiseraWorklist.GetTestResultsForAntiseraWorklist((Guid)drUnit[TABLES.BloodUnit.BloodUnitGuid],(Guid)drRackLot["AntiseraWorklistTypingGuid"]);
			//
			DataTable testTypes = BOL.BloodTestType.GetBloodTestTypes(drRackLot[TABLES.OrderableTest.OrderableTestId].ToString());
			//
			foreach(DataRow result in results.Rows)
			{
				DataRow[] relevantTest = testTypes.Select(TABLES.BloodTestType.BloodTestTypeId+" = '" + result[TABLES.BloodTestType.BloodTestTypeId].ToString() + "'");
				if (relevantTest.Length >0)
				{
					string bloodTestType = relevantTest[0][TABLES.BloodTestType.BloodTestName].ToString();
					if (bloodTestType.IndexOf(ARTIFICIAL.AHG) > -1)
					{
						dr[ARTIFICIAL.AHGGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.AHGRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf(ARTIFICIAL.CC) > -1)
					{
						dr[ARTIFICIAL.CCGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.CCRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf(ARTIFICIAL.Interp) > -1)
					{
						dr[ARTIFICIAL.InterpGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.InterpRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
				}
			}
			//
			dtAGC.Rows.Add(dr);
			//
			//Now create control table
			//
			DataTable dtWorklistQCResults = BOL.AntiseraWorklist.GetAntiseraWorklistQCResults((Guid)drRackLot[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid]);
			//
			DataTable dtCtrl = new DataTable(ARTIFICIAL.Control);
			dtCtrl.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.Control, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.ReagentType,typeof(string));
			dtCtrl.Columns.Add(TABLES.Reagent.LotNumber, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.VialId, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.IS,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.RT,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.C37,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.AHG,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlInterp, typeof(string));			
			dtCtrl.Columns.Add(ARTIFICIAL.ControlComment, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.SystemControlInterp, typeof(string));
			dtCtrl.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlReagentGuid, typeof(Guid));
			dtCtrl.Columns.Add(TABLES.Reagent.ReagentManufacturerName, typeof(string));
			dtCtrl.Columns.Add(TABLES.Reagent.LotExpirationDate, typeof(DateTime));
			dtCtrl.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.ISGuid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.RTGuid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.C37Guid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.AHGGuid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlInterpGuid, typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.ISRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.RTRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.C37RowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.AHGRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.CCRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.InterpRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlInterpSave, typeof(bool));
			dtCtrl.Columns.Add(TABLES.VamcDivision.DivisionCode, typeof(string));
			dtCtrl.Columns.Add(TABLES.RackLot.TestWithId, typeof(int));
			dtCtrl.Columns.Add(ARTIFICIAL.OverrideComment, typeof(string));
			//
			DataRow drPos = dtCtrl.NewRow();
			drPos[ARTIFICIAL.Indicator] = "";
			drPos[ARTIFICIAL.Control] = "POS";
			drPos[ARTIFICIAL.ReagentType] = dtReagents.Rows[1][TABLES.ReagentType.ReagentTypeId];
			drPos[TABLES.Reagent.LotNumber] = dtReagents.Rows[1][TABLES.Reagent.LotNumber];
			drPos[ARTIFICIAL.VialId] = "1";
			drPos[ARTIFICIAL.AHG] = "2";
			drPos[ARTIFICIAL.CC] = "2";
			drPos[ARTIFICIAL.ControlInterp] = "P";
			drPos[ARTIFICIAL.ControlComment] = "Unit Testing";
			drPos[ARTIFICIAL.SystemControlInterp] = "P";
			drPos[TABLES.Reagent.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drPos[ARTIFICIAL.ControlReagentGuid] = dtReagents.Rows[1][TABLES.Reagent.ReagentGuid];
			drPos[TABLES.Reagent.ReagentManufacturerName] = dtReagents.Rows[1][TABLES.Reagent.ReagentManufacturerName].ToString();
			drPos[TABLES.Reagent.LotExpirationDate] = dtReagents.Rows[1][TABLES.Reagent.LotExpirationDate];
			drPos[TABLES.ReactivityPhase.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.AHGandCC).ToString();
			drPos[ARTIFICIAL.IndicatorMessage] = "";
			drPos[ARTIFICIAL.PartiallyCompleted] = false;
			drPos[ARTIFICIAL.ISGuid] = Guid.Empty;
			drPos[ARTIFICIAL.RTGuid] = Guid.Empty;
			drPos[ARTIFICIAL.C37Guid] = Guid.Empty;
			drPos[ARTIFICIAL.AHGGuid] = Guid.NewGuid();
			drPos[ARTIFICIAL.CCGuid] = Guid.NewGuid();
			drPos[ARTIFICIAL.ControlInterpGuid] = Guid.NewGuid();
			drPos[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.RTRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.ISSave] = false;
			drPos[ARTIFICIAL.RTSave] = false;
			drPos[ARTIFICIAL.C37Save] = false;
			drPos[ARTIFICIAL.AHGSave] = true;
			drPos[ARTIFICIAL.CCSave] = true;
			drPos[ARTIFICIAL.ControlInterpSave] = true;
			drPos[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drPos[TABLES.RackLot.TestWithId] = DBNull.Value;
			drPos[ARTIFICIAL.OverrideComment] = "Unit Test 1705";
			//
			dtCtrl.Rows.Add(drPos);
			//
			DataRow drNeg = dtCtrl.NewRow();
			drNeg[ARTIFICIAL.Indicator] = "";
			drNeg[ARTIFICIAL.Control] = "NEG";
			drNeg[ARTIFICIAL.ReagentType] = dtReagents.Rows[2][TABLES.ReagentType.ReagentTypeId];
			drNeg[TABLES.Reagent.LotNumber] = dtReagents.Rows[2][TABLES.Reagent.LotNumber];
			drNeg[ARTIFICIAL.VialId] = "0";
			drNeg[ARTIFICIAL.AHG] = "0";
			drNeg[ARTIFICIAL.CC] = "2";
			drNeg[ARTIFICIAL.ControlInterp] = "N";
			drNeg[ARTIFICIAL.ControlComment] = "Unit Testing";
			drNeg[ARTIFICIAL.SystemControlInterp] = "N";
			drNeg[TABLES.Reagent.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drNeg[ARTIFICIAL.ControlReagentGuid] = dtReagents.Rows[2][TABLES.Reagent.ReagentGuid];
			drNeg[TABLES.Reagent.ReagentManufacturerName] = dtReagents.Rows[2][TABLES.Reagent.ReagentManufacturerName];
			drNeg[TABLES.Reagent.LotExpirationDate] = dtReagents.Rows[2][TABLES.Reagent.LotExpirationDate];
			drNeg[TABLES.ReactivityPhase.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.AHGandCC).ToString();
			drNeg[ARTIFICIAL.IndicatorMessage] = "";
			drNeg[ARTIFICIAL.PartiallyCompleted] = false;
			drNeg[ARTIFICIAL.ISGuid] = Guid.Empty;
			drNeg[ARTIFICIAL.RTGuid] = Guid.Empty;
			drNeg[ARTIFICIAL.C37Guid] = Guid.Empty;
			drNeg[ARTIFICIAL.AHGGuid] = Guid.NewGuid();
			drNeg[ARTIFICIAL.CCGuid] = Guid.NewGuid();
			drNeg[ARTIFICIAL.ControlInterpGuid] = Guid.NewGuid();
			drNeg[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.RTRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.ISSave] = false;
			drNeg[ARTIFICIAL.RTSave] = false;
			drNeg[ARTIFICIAL.C37Save] = false;
			drNeg[ARTIFICIAL.AHGSave] = true;
			drNeg[ARTIFICIAL.CCSave] = true;
			drNeg[ARTIFICIAL.ControlInterpSave] = true;
			drNeg[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drNeg[TABLES.RackLot.TestWithId] = DBNull.Value;
			drNeg[ARTIFICIAL.OverrideComment] = "Unit Test 1705";
			//
			dtCtrl.Rows.Add(drNeg);
			//
			foreach(DataRow result in dtWorklistQCResults.Rows)
			{
				string phase = result[TABLES.RackTest.RackTestResultTypeCode].ToString().Trim();
				//
				if ((bool)result[TABLES.RackLot.ControlCellId])
				{
					drPos[ARTIFICIAL.InterpRowVersion] = result[ARTIFICIAL.RackLotRowVersion];
					drPos[ARTIFICIAL.ControlInterpGuid] = result[TABLES.RackLot.RackLotGuid];
					drPos[TABLES.RackLot.TestWithId] = result[TABLES.RackLot.TestWithId];
					//
					if (phase == ARTIFICIAL.AHG)
					{
						drPos[ARTIFICIAL.AHGGuid] = result[TABLES.RackTest.RackTestGuid];
						drPos[ARTIFICIAL.AHGRowVersion] = result[TABLES.RackTest.RowVersion];
					}
					else if (phase == ARTIFICIAL.CC)
					{
						drPos[ARTIFICIAL.CCGuid] = result[TABLES.RackTest.RackTestGuid];
						drPos[ARTIFICIAL.CCRowVersion] = result[TABLES.RackTest.RowVersion];
					}
				}
				else
				{
					drNeg[ARTIFICIAL.InterpRowVersion] = result[ARTIFICIAL.RackLotRowVersion];
					drNeg[ARTIFICIAL.ControlInterpGuid] = result[TABLES.RackLot.RackLotGuid];
					drNeg[TABLES.RackLot.TestWithId] = result[TABLES.RackLot.TestWithId];
					//
					//
					if (phase == ARTIFICIAL.AHG)
					{
						drNeg[ARTIFICIAL.AHGGuid] = result[TABLES.RackTest.RackTestGuid];
						drNeg[ARTIFICIAL.AHGRowVersion] = result[TABLES.RackTest.RowVersion];
					}
					else if (phase == ARTIFICIAL.CC)
					{
						drNeg[ARTIFICIAL.CCGuid] = result[TABLES.RackTest.RackTestGuid];
						drNeg[ARTIFICIAL.CCRowVersion] = result[TABLES.RackTest.RowVersion];
					}
				}
				//
			}
			//
			//Finally, after setting up all that data, we can test the method!!!!!!!!! Nice!
			//
			ArrayList workloadProcessIds = new ArrayList(1);
			workloadProcessIds.Add(Common.WorkloadProcessID.Unknown);
			bool retValue = BOL.BloodUnitTest.SaveAntigenTypingBloodUnitTests((Guid)drRackLot[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid],tmpAW,dtAGC,dtCtrl, Convert.ToInt32(Common.ReactivityPhase.AHGandCC).ToString(), Common.UpdateFunction.UC041FrmRecordPhenotypeResults, workloadProcessIds, buGuids, false);  
			//
			Assert.IsTrue(retValue);
		}

		[Test]
		public void SaveAntigenTypingBloodUnitTests_ISRT_Pass()
		{
			//
			//Create new Anti-c reagent to test against.
			DataTable dtReagents = Reagent.InitializeReagentsAndManufacturersTable();
			DataRow drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = Guid.NewGuid();
			drReagent[TABLES.ReagentType.ReagentTypeId] = 7; //Anti-C
			drReagent["ReagentName"] = "Test c Reagent";
			drReagent["ReceiptDate"] = DateTime.Now;
			drReagent["ReceiptTechId"] = UnitTestConfig.User_Technologist;
			drReagent["InvoiceNumber"] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "c"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent["NumberVialsReceived"] = 20;
			drReagent["NumberVialsAvailable"] = 15;
			drReagent["Comments"] = "Unit Test 7039";
			drReagent["InspectionIndicator"] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent["ReagentTypeName"] = "Anti-c";
			drReagent[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drReagent["RecordStatusCode"] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Create new Screening Cells reagent to for Pos control.
			drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = Guid.NewGuid();
			drReagent[TABLES.ReagentType.ReagentTypeId] = 63; //Screening Cells
			drReagent["ReagentName"] = "Test SC Reagent";
			drReagent["ReceiptDate"] = DateTime.Now;
			drReagent["ReceiptTechId"] = UnitTestConfig.User_Technologist;
			drReagent["InvoiceNumber"] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "SC"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent["NumberVialsReceived"] = 20;
			drReagent["NumberVialsAvailable"] = 15;
			drReagent["Comments"] = "Unit Test 7039";
			drReagent["InspectionIndicator"] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent["ReagentTypeName"] = "Screening Cells";
			drReagent[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drReagent["RecordStatusCode"] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Create new Check Cells reagent to for Neg control.
			drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = Guid.NewGuid();
			drReagent[TABLES.ReagentType.ReagentTypeId] = 56; //Check Cells
			drReagent["ReagentName"] = "Test CC Reagent";
			drReagent["ReceiptDate"] = DateTime.Now;
			drReagent["ReceiptTechId"] = UnitTestConfig.User_Technologist;
			drReagent["InvoiceNumber"] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = ARTIFICIAL.CC+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent["NumberVialsReceived"] = 20;
			drReagent["NumberVialsAvailable"] = 15;
			drReagent["Comments"] = "Unit Test 7039";
			drReagent["InspectionIndicator"] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent["ReagentTypeName"] = "Check Cells";
			drReagent[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drReagent["RecordStatusCode"] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Insert new reagents
			BOL.Reagent.InsertNewReagent(dtReagents, BOL.ReagentType.GetReagentTypes(), Common.UpdateFunction.UnitTests);
			//
			Guid buGuid = (Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			Guid[] buGuids = new Guid[] {buGuid};
			//
			//Now we will insert a new antisera worklist
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(Guid.NewGuid());
			tmpAW.TestingMethodCode = Common.TestingMethod.Solid;
			tmpAW.WorklistCreateDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			tmpAW.WorklistName = Environment.UserName;
			//
			DataTable tmpAWT = new DataTable();
			tmpAWT.Columns.Add("AntiseraWorklistTypingGuid", typeof(Guid));
			tmpAWT.Columns.Add(TABLES.AntiseraWorklist.AntiseraWorklistGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.ReagentGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.RackGuid,typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.ReactivityPhaseCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.Comments,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.DivisionCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.TestWithId,typeof(int));
			tmpAWT.Columns.Add("RackQCOverrideComment",typeof(string));
			tmpAWT.Columns.Add("ExpiredOverrideComment",typeof(string));
			tmpAWT.Columns.Add("PhaseOverrideComment",typeof(string));
			//
			DataRow drAWT = tmpAWT.NewRow();
			drAWT[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid] = Guid.NewGuid();
			drAWT[TABLES.AntiseraWorklist.AntiseraWorklistGuid] = tmpAW.AntiseraWorklistGuid;
			drAWT[TABLES.OrderableTest.OrderableTestId] = Convert.ToInt32(Common.OrderableTest.AGc).ToString();
			drAWT[TABLES.RackLot.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drAWT[TABLES.RackLot.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.ISandRT).ToString();
			drAWT[TABLES.RackLot.Comments] = "";
			drAWT[TABLES.RackLot.DivisionCode] = this.TestDivisionCode;
			tmpAWT.Rows.Add(drAWT);
			//
			//Save the antisera worklist
			tmpAW.Save(tmpAWT,this._dtBloodUnit,Environment.UserName,Common.UpdateFunction.UnitTests,new Guid[] {buGuid}, Guid.Empty, null, false);
			//
			//Now we need to load the saved antisera worklist, complete the tests and save again.
			BOL.AntiseraWorklist aw = new BOL.AntiseraWorklist(tmpAW.AntiseraWorklistGuid);
			DataTable dtAWT = BOL.AntiseraWorklist.GetAntiseraWorklistDetails(tmpAW.AntiseraWorklistGuid);
			DataTable dtUnits = BOL.AntiseraWorklist.GetAntiseraWorklistUnits(tmpAW.AntiseraWorklistGuid);
			//
			DataRow drRackLot = dtAWT.Rows[0];
			DataRow drUnit = dtUnits.Rows[0];
			DataRow drCReagent = dtReagents.Rows[0];
			//
			//Now create AGc grid table
			DataTable dtAGC = new DataTable("Phenotype");
			//
			dtAGC.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtAGC.Columns.Add(TABLES.ExceptionUnitIssue.UnitId, typeof(string));
			dtAGC.Columns.Add(TABLES.BloodProduct.ProductName, typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.IS,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.RT,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.C37,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.AHG,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.Interp, typeof(string));			
			dtAGC.Columns.Add(ARTIFICIAL.Comment, typeof(string));
			dtAGC.Columns.Add(TABLES.ValidRhResult.SystemInterp, typeof(string));
			dtAGC.Columns.Add(TABLES.BloodUnit.BloodUnitGuid, typeof(Guid));
			dtAGC.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dtAGC.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(string));
			dtAGC.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.ISGuid,typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.RTGuid,typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.C37Guid,typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.AHGGuid,typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.InterpGuid, typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.ISRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.RTRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.C37RowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.AHGRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.CCRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.InterpRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.InterpSave, typeof(bool));
			dtAGC.Columns.Add(TABLES.BloodUnitStatus.QuarantineIndicator, typeof(bool));
			dtAGC.Columns.Add(TABLES.VamcDivision.DivisionCode, typeof(string));
			dtAGC.Columns.Add(TABLES.ExceptionQc.ExceptionComment, typeof(string));
			//
			DataRow dr = dtAGC.NewRow();
			dr[ARTIFICIAL.Indicator] = "";
			dr[TABLES.ExceptionUnitIssue.UnitId] = drUnit[TABLES.BloodUnit.EyeReadableUnitId];
			dr[TABLES.BloodProduct.ProductName] = drUnit[TABLES.BloodProduct.ProductShortName];
			dr[ARTIFICIAL.IS] = "4";
			dr[ARTIFICIAL.RT] = "4";
			dr[ARTIFICIAL.Interp] = "P";
			dr[ARTIFICIAL.Comment] = "Unit Testing";
			dr[TABLES.ValidRhResult.SystemInterp] = "P";
			dr[TABLES.BloodUnit.BloodUnitGuid] = drUnit[TABLES.BloodUnit.BloodUnitGuid];
			dr[TABLES.Reagent.ReagentGuid] = drCReagent[TABLES.Reagent.ReagentGuid];
			dr[TABLES.ReactivityPhase.ReactivityPhaseCode] = drRackLot[TABLES.ReactivityPhase.ReactivityPhaseCode];
			dr[TABLES.OrderableTest.OrderableTestId] = Convert.ToInt32(Common.OrderableTest.AGc);
			dr[ARTIFICIAL.IndicatorMessage] = "";
			dr[ARTIFICIAL.PartiallyCompleted] = false;
			dr[ARTIFICIAL.ISGuid] = Guid.Empty;
			dr[ARTIFICIAL.RTGuid] = Guid.Empty;
			dr[ARTIFICIAL.C37Guid] = Guid.Empty;
			dr[ARTIFICIAL.AHGGuid] = Guid.Empty;
			dr[ARTIFICIAL.CCGuid] = Guid.Empty;
			dr[ARTIFICIAL.InterpGuid] = Guid.Empty;
			dr[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.RTRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			dr[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.ISSave] = true;
			dr[ARTIFICIAL.RTSave] = true;
			dr[ARTIFICIAL.C37Save] = false;
			dr[ARTIFICIAL.AHGSave] = false;
			dr[ARTIFICIAL.CCSave] = false;
			dr[ARTIFICIAL.InterpSave] = true;
			dr[TABLES.BloodUnitStatus.QuarantineIndicator] = false;
			//
			DataTable results = BOL.AntiseraWorklist.GetTestResultsForAntiseraWorklist((Guid)drUnit[TABLES.BloodUnit.BloodUnitGuid],(Guid)drRackLot["AntiseraWorklistTypingGuid"]);
			//
			DataTable testTypes = BOL.BloodTestType.GetBloodTestTypes(drRackLot[TABLES.OrderableTest.OrderableTestId].ToString());
			//
			foreach(DataRow result in results.Rows)
			{
				DataRow[] relevantTest = testTypes.Select(TABLES.BloodTestType.BloodTestTypeId+" = '" + result[TABLES.BloodTestType.BloodTestTypeId].ToString() + "'");
				if (relevantTest.Length >0)
				{
					string bloodTestType = relevantTest[0][TABLES.BloodTestType.BloodTestName].ToString();
					if (bloodTestType.IndexOf(ARTIFICIAL.IS) > -1)
					{
						dr[ARTIFICIAL.ISGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.ISRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf(ARTIFICIAL.RT) > -1)
					{
						dr[ARTIFICIAL.RTGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.RTRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf(ARTIFICIAL.Interp) > -1)
					{
						dr[ARTIFICIAL.InterpGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.InterpRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
				}
			}
			//
			dtAGC.Rows.Add(dr);
			//
			//Now create control table
			//
			DataTable dtWorklistQCResults = BOL.AntiseraWorklist.GetAntiseraWorklistQCResults((Guid)drRackLot[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid]);
			//
			DataTable dtCtrl = new DataTable(ARTIFICIAL.Control);
			dtCtrl.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.Control, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.ReagentType,typeof(string));
			dtCtrl.Columns.Add(TABLES.Reagent.LotNumber, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.VialId, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.IS,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.RT,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.C37,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.AHG,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlInterp, typeof(string));			
			dtCtrl.Columns.Add(ARTIFICIAL.ControlComment, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.SystemControlInterp, typeof(string));
			dtCtrl.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlReagentGuid, typeof(Guid));
			dtCtrl.Columns.Add(TABLES.Reagent.ReagentManufacturerName, typeof(string));
			dtCtrl.Columns.Add(TABLES.Reagent.LotExpirationDate, typeof(DateTime));
			dtCtrl.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.ISGuid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.RTGuid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.C37Guid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.AHGGuid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlInterpGuid, typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.ISRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.RTRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.C37RowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.AHGRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.CCRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.InterpRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlInterpSave, typeof(bool));
			dtCtrl.Columns.Add(TABLES.VamcDivision.DivisionCode, typeof(string));
			dtCtrl.Columns.Add(TABLES.RackLot.TestWithId, typeof(int));
			dtCtrl.Columns.Add(ARTIFICIAL.OverrideComment, typeof(string));
			//
			DataRow drPos = dtCtrl.NewRow();
			drPos[ARTIFICIAL.Indicator] = "";
			drPos[ARTIFICIAL.Control] = "POS";
			drPos[ARTIFICIAL.ReagentType] = dtReagents.Rows[1][TABLES.ReagentType.ReagentTypeId];
			drPos[TABLES.Reagent.LotNumber] = dtReagents.Rows[1][TABLES.Reagent.LotNumber];
			drPos[ARTIFICIAL.VialId] = "1";
			drPos[ARTIFICIAL.IS] = "0";
			drPos[ARTIFICIAL.RT] = "W";
			drPos[ARTIFICIAL.ControlInterp] = "I";
			drPos[ARTIFICIAL.ControlComment] = "Unit Testing";
			drPos[ARTIFICIAL.SystemControlInterp] = "I";
			drPos[TABLES.Reagent.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drPos[ARTIFICIAL.ControlReagentGuid] = dtReagents.Rows[1][TABLES.Reagent.ReagentGuid];
			drPos[TABLES.Reagent.ReagentManufacturerName] = dtReagents.Rows[1][TABLES.Reagent.ReagentManufacturerName].ToString();
			drPos[TABLES.Reagent.LotExpirationDate] = dtReagents.Rows[1][TABLES.Reagent.LotExpirationDate];
			drPos[TABLES.ReactivityPhase.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.ISandRT).ToString();
			drPos[ARTIFICIAL.IndicatorMessage] = "";
			drPos[ARTIFICIAL.PartiallyCompleted] = false;
			drPos[ARTIFICIAL.ISGuid] = Guid.NewGuid();
			drPos[ARTIFICIAL.RTGuid] = Guid.NewGuid();
			drPos[ARTIFICIAL.C37Guid] = Guid.Empty;
			drPos[ARTIFICIAL.AHGGuid] = Guid.Empty;
			drPos[ARTIFICIAL.CCGuid] = Guid.Empty;
			drPos[ARTIFICIAL.ControlInterpGuid] = Guid.NewGuid();
			drPos[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.RTRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.ISSave] = true;
			drPos[ARTIFICIAL.RTSave] = true;
			drPos[ARTIFICIAL.C37Save] = false;
			drPos[ARTIFICIAL.AHGSave] = false;
			drPos[ARTIFICIAL.CCSave] = false;
			drPos[ARTIFICIAL.ControlInterpSave] = true;
			drPos[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drPos[TABLES.RackLot.TestWithId] = DBNull.Value;
			//
			dtCtrl.Rows.Add(drPos);
			//
			DataRow drNeg = dtCtrl.NewRow();
			drNeg[ARTIFICIAL.Indicator] = "";
			drNeg[ARTIFICIAL.Control] = "NEG";
			drNeg[ARTIFICIAL.ReagentType] = dtReagents.Rows[2][TABLES.ReagentType.ReagentTypeId];
			drNeg[TABLES.Reagent.LotNumber] = dtReagents.Rows[2][TABLES.Reagent.LotNumber];
			drNeg[ARTIFICIAL.VialId] = "0";
			drNeg[ARTIFICIAL.IS] = "0";
			drNeg[ARTIFICIAL.C37] = "W";
			drNeg[ARTIFICIAL.ControlInterp] = "I";
			drNeg[ARTIFICIAL.ControlComment] = "Unit Testing";
			drNeg[ARTIFICIAL.SystemControlInterp] = "I";
			drNeg[TABLES.Reagent.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drNeg[ARTIFICIAL.ControlReagentGuid] = dtReagents.Rows[2][TABLES.Reagent.ReagentGuid];
			drNeg[TABLES.Reagent.ReagentManufacturerName] = dtReagents.Rows[2][TABLES.Reagent.ReagentManufacturerName];
			drNeg[TABLES.Reagent.LotExpirationDate] = dtReagents.Rows[2][TABLES.Reagent.LotExpirationDate];
			drNeg[TABLES.ReactivityPhase.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.ISandRT).ToString();
			drNeg[ARTIFICIAL.IndicatorMessage] = "";
			drNeg[ARTIFICIAL.PartiallyCompleted] = false;
			drNeg[ARTIFICIAL.ISGuid] = Guid.NewGuid();
			drNeg[ARTIFICIAL.RTGuid] = Guid.NewGuid();
			drNeg[ARTIFICIAL.C37Guid] = Guid.Empty;
			drNeg[ARTIFICIAL.AHGGuid] = Guid.Empty;
			drNeg[ARTIFICIAL.CCGuid] = Guid.Empty;
			drNeg[ARTIFICIAL.ControlInterpGuid] = Guid.NewGuid();
			drNeg[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.RTRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.ISSave] = true;
			drNeg[ARTIFICIAL.RTSave] = true;
			drNeg[ARTIFICIAL.C37Save] = false;
			drNeg[ARTIFICIAL.AHGSave] = false;
			drNeg[ARTIFICIAL.CCSave] = false;
			drNeg[ARTIFICIAL.ControlInterpSave] = true;
			drNeg[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drNeg[TABLES.RackLot.TestWithId] = DBNull.Value;
			//
			dtCtrl.Rows.Add(drNeg);
			//
			foreach(DataRow result in dtWorklistQCResults.Rows)
			{
				string phase = result[TABLES.RackTest.RackTestResultTypeCode].ToString().Trim();
				//
				if ((bool)result[TABLES.RackLot.ControlCellId])
				{
					drPos[ARTIFICIAL.InterpRowVersion] = result[ARTIFICIAL.RackLotRowVersion];
					drPos[ARTIFICIAL.ControlInterpGuid] = result[TABLES.RackLot.RackLotGuid];
					drPos[TABLES.RackLot.TestWithId] = result[TABLES.RackLot.TestWithId];
					//
					if (phase == ARTIFICIAL.IS)
					{
						drPos[ARTIFICIAL.ISGuid] = result[TABLES.RackTest.RackTestGuid];
						drPos[ARTIFICIAL.ISRowVersion] = result[TABLES.RackTest.RowVersion];
					}
					else if (phase == ARTIFICIAL.RT)
					{
						drPos[ARTIFICIAL.RTGuid] = result[TABLES.RackTest.RackTestGuid];
						drPos[ARTIFICIAL.RTRowVersion] = result[TABLES.RackTest.RowVersion];
					}
				}
				else
				{
					drNeg[ARTIFICIAL.InterpRowVersion] = result[ARTIFICIAL.RackLotRowVersion];
					drNeg[ARTIFICIAL.ControlInterpGuid] = result[TABLES.RackLot.RackLotGuid];
					drNeg[TABLES.RackLot.TestWithId] = result[TABLES.RackLot.TestWithId];
					//
					//
					if (phase == ARTIFICIAL.IS)
					{
						drNeg[ARTIFICIAL.ISGuid] = result[TABLES.RackTest.RackTestGuid];
						drNeg[ARTIFICIAL.ISRowVersion] = result[TABLES.RackTest.RowVersion];
					}
					else if (phase == ARTIFICIAL.RT)
					{
						drNeg[ARTIFICIAL.RTGuid] = result[TABLES.RackTest.RackTestGuid];
						drNeg[ARTIFICIAL.RTRowVersion] = result[TABLES.RackTest.RowVersion];
					}
				}
				//
			}
			//
			//Finally, after setting up all that data, we can test the method!!!!!!!!! Nice!
			//
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UnitAntigenPhenotypingMultipleTestPhases);
			ArrayList workloadProcessIds = new ArrayList(1);
			workloadProcessIds.Add(Common.WorkloadProcessID.UnitAntigenPhenotypingMultipleTestPhases);
			bool retValue = BOL.BloodUnitTest.SaveAntigenTypingBloodUnitTests((Guid)drRackLot[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid],tmpAW,dtAGC,dtCtrl, Convert.ToInt32(Common.ReactivityPhase.ISandRT).ToString(), Common.UpdateFunction.UC041FrmRecordPhenotypeResults, workloadProcessIds, buGuids, false);  
			//
			Assert.IsTrue(retValue);
		}

		[Test]
		public void SaveAntigenTypingBloodUnitTests_IS37_Pass()
		{
			//Create new Anti-e reagent to test against.
			DataTable dtReagents = Reagent.InitializeReagentsAndManufacturersTable();
			DataRow drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = Guid.NewGuid();
			drReagent[TABLES.ReagentType.ReagentTypeId] = 13; //Anti-e
			drReagent["ReagentName"] = "Test e Reagent";
			drReagent["ReceiptDate"] = DateTime.Now;
			drReagent["ReceiptTechId"] = UnitTestConfig.User_Technologist;
			drReagent["InvoiceNumber"] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "e"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent["NumberVialsReceived"] = 20;
			drReagent["NumberVialsAvailable"] = 15;
			drReagent["Comments"] = "Unit Test 7040";
			drReagent["InspectionIndicator"] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent["ReagentTypeName"] = "Anti-e";
			drReagent[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drReagent["RecordStatusCode"] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Create new Screening Cells reagent to for Pos control.
			drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = Guid.NewGuid();
			drReagent[TABLES.ReagentType.ReagentTypeId] = 63; //Screening Cells
			drReagent["ReagentName"] = "Test SC Reagent";
			drReagent["ReceiptDate"] = DateTime.Now;
			drReagent["ReceiptTechId"] = UnitTestConfig.User_Technologist;
			drReagent["InvoiceNumber"] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "SC"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent["NumberVialsReceived"] = 20;
			drReagent["NumberVialsAvailable"] = 15;
			drReagent["Comments"] = "Unit Test 7040";
			drReagent["InspectionIndicator"] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent["ReagentTypeName"] = "Screening Cells";
			drReagent[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drReagent["RecordStatusCode"] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Create new Check Cells reagent to for Neg control.
			drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = Guid.NewGuid();
			drReagent[TABLES.ReagentType.ReagentTypeId] = 56; //Check Cells
			drReagent["ReagentName"] = "Test CC Reagent";
			drReagent["ReceiptDate"] = DateTime.Now;
			drReagent["ReceiptTechId"] = UnitTestConfig.User_Technologist;
			drReagent["InvoiceNumber"] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = ARTIFICIAL.CC+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent["NumberVialsReceived"] = 20;
			drReagent["NumberVialsAvailable"] = 15;
			drReagent["Comments"] = "Unit Test 7040";
			drReagent["InspectionIndicator"] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent["ReagentTypeName"] = "Check Cells";
			drReagent[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drReagent["RecordStatusCode"] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Insert new reagents
			BOL.Reagent.InsertNewReagent(dtReagents, BOL.ReagentType.GetReagentTypes(), Common.UpdateFunction.UnitTests);
			//
			Guid buGuid = (Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			Guid[] buGuids = new Guid[] {buGuid};
			//
			//Now we will insert a new antisera worklist
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(Guid.NewGuid());
			tmpAW.TestingMethodCode = Common.TestingMethod.Tube;
			tmpAW.WorklistCreateDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			tmpAW.WorklistName = Environment.UserName;
			//
			DataTable tmpAWT = new DataTable();
			tmpAWT.Columns.Add("AntiseraWorklistTypingGuid", typeof(Guid));
			tmpAWT.Columns.Add(TABLES.AntiseraWorklist.AntiseraWorklistGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.ReagentGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.RackGuid,typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.ReactivityPhaseCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.Comments,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.DivisionCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.TestWithId,typeof(int));
			tmpAWT.Columns.Add("RackQCOverrideComment",typeof(string));
			tmpAWT.Columns.Add("ExpiredOverrideComment",typeof(string));
			tmpAWT.Columns.Add("PhaseOverrideComment",typeof(string));
			//
			DataRow drAWT = tmpAWT.NewRow();
			drAWT[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid] = Guid.NewGuid();
			drAWT[TABLES.AntiseraWorklist.AntiseraWorklistGuid] = tmpAW.AntiseraWorklistGuid;
			drAWT[TABLES.OrderableTest.OrderableTestId] = Convert.ToInt32(Common.OrderableTest.AGe).ToString();
			drAWT[TABLES.RackLot.RackGuid] = Guid.Empty;
			drAWT[TABLES.RackLot.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drAWT[TABLES.RackLot.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.ISand37).ToString();
			drAWT[TABLES.RackLot.Comments] = "";
			drAWT[TABLES.RackLot.DivisionCode] = this.TestDivisionCode;
			tmpAWT.Rows.Add(drAWT);
			//
			//Save the antisera worklist
			tmpAW.Save(tmpAWT,this._dtBloodUnit,Environment.UserName,Common.UpdateFunction.UnitTests,new Guid[] {buGuid}, Guid.Empty, null, false);
			//
			//Now we need to load the saved antisera worklist, complete the tests and save again.
			BOL.AntiseraWorklist aw = new BOL.AntiseraWorklist(tmpAW.AntiseraWorklistGuid);
			DataTable dtAWT = BOL.AntiseraWorklist.GetAntiseraWorklistDetails(tmpAW.AntiseraWorklistGuid);
			DataTable dtUnits = BOL.AntiseraWorklist.GetAntiseraWorklistUnits(tmpAW.AntiseraWorklistGuid);
			//
			DataRow drRackLot = dtAWT.Rows[0];
			DataRow drUnit = dtUnits.Rows[0];
			DataRow drCReagent = dtReagents.Rows[0];
			//
			//Now create AGe grid table
			DataTable dtAGC = new DataTable("Phenotype");
			//
			dtAGC.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtAGC.Columns.Add(TABLES.ExceptionUnitIssue.UnitId, typeof(string));
			dtAGC.Columns.Add(TABLES.BloodProduct.ProductName, typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.IS,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.RT,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.C37,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.AHG,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.Interp, typeof(string));			
			dtAGC.Columns.Add(ARTIFICIAL.Comment, typeof(string));
			dtAGC.Columns.Add(TABLES.ValidRhResult.SystemInterp, typeof(string));
			dtAGC.Columns.Add(TABLES.BloodUnit.BloodUnitGuid, typeof(Guid));
			dtAGC.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dtAGC.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(string));
			dtAGC.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.ISGuid,typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.RTGuid,typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.C37Guid,typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.AHGGuid,typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.InterpGuid, typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.ISRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.RTRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.C37RowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.AHGRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.CCRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.InterpRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.InterpSave, typeof(bool));
			dtAGC.Columns.Add(TABLES.BloodUnitStatus.QuarantineIndicator, typeof(bool));
			dtAGC.Columns.Add(TABLES.VamcDivision.DivisionCode, typeof(string));
			dtAGC.Columns.Add(TABLES.ExceptionQc.ExceptionComment, typeof(string));
			//
			DataRow dr = dtAGC.NewRow();
			dr[ARTIFICIAL.Indicator] = "";
			dr[TABLES.ExceptionUnitIssue.UnitId] = drUnit[TABLES.BloodUnit.EyeReadableUnitId];
			dr[TABLES.BloodProduct.ProductName] = drUnit[TABLES.BloodProduct.ProductShortName];
			dr[ARTIFICIAL.IS] = "4";
			dr[ARTIFICIAL.C37] = "4";
			dr[ARTIFICIAL.Interp] = "P";
			dr[ARTIFICIAL.Comment] = "Unit Testing";
			dr[TABLES.ValidRhResult.SystemInterp] = "P";
			dr[TABLES.BloodUnit.BloodUnitGuid] = drUnit[TABLES.BloodUnit.BloodUnitGuid];
			dr[TABLES.Reagent.ReagentGuid] = drCReagent[TABLES.Reagent.ReagentGuid];
			dr[TABLES.ReactivityPhase.ReactivityPhaseCode] = drRackLot[TABLES.ReactivityPhase.ReactivityPhaseCode];
			dr[TABLES.OrderableTest.OrderableTestId] = Convert.ToInt32(Common.OrderableTest.AGe);
			dr[ARTIFICIAL.IndicatorMessage] = "";
			dr[ARTIFICIAL.PartiallyCompleted] = false;
			dr[ARTIFICIAL.ISGuid] = Guid.Empty;
			dr[ARTIFICIAL.RTGuid] = Guid.Empty;
			dr[ARTIFICIAL.C37Guid] = Guid.Empty;
			dr[ARTIFICIAL.AHGGuid] = Guid.Empty;
			dr[ARTIFICIAL.CCGuid] = Guid.Empty;
			dr[ARTIFICIAL.InterpGuid] = Guid.Empty;
			dr[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.RTRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			dr[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.ISSave] = true;
			dr[ARTIFICIAL.RTSave] = false;
			dr[ARTIFICIAL.C37Save] = true;
			dr[ARTIFICIAL.AHGSave] = false;
			dr[ARTIFICIAL.CCSave] = false;
			dr[ARTIFICIAL.InterpSave] = true;
			dr[TABLES.BloodUnitStatus.QuarantineIndicator] = false;
			//
			DataTable results = BOL.AntiseraWorklist.GetTestResultsForAntiseraWorklist((Guid)drUnit[TABLES.BloodUnit.BloodUnitGuid],(Guid)drRackLot["AntiseraWorklistTypingGuid"]);
			//
			DataTable testTypes = BOL.BloodTestType.GetBloodTestTypes(drRackLot[TABLES.OrderableTest.OrderableTestId].ToString());
			//
			foreach(DataRow result in results.Rows)
			{
				DataRow[] relevantTest = testTypes.Select(TABLES.BloodTestType.BloodTestTypeId+" = '" + result[TABLES.BloodTestType.BloodTestTypeId].ToString() + "'");
				if (relevantTest.Length >0)
				{
					string bloodTestType = relevantTest[0][TABLES.BloodTestType.BloodTestName].ToString();
					if (bloodTestType.IndexOf(ARTIFICIAL.IS) > -1)
					{
						dr[ARTIFICIAL.ISGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.ISRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf(ARTIFICIAL.C37) > -1)
					{
						dr[ARTIFICIAL.C37Guid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.C37RowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf(ARTIFICIAL.Interp) > -1)
					{
						dr[ARTIFICIAL.InterpGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.InterpRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
				}
			}
			//
			dtAGC.Rows.Add(dr);
			//
			//Now create control table
			//
			DataTable dtWorklistQCResults = BOL.AntiseraWorklist.GetAntiseraWorklistQCResults((Guid)drRackLot[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid]);
			//
			DataTable dtCtrl = new DataTable(ARTIFICIAL.Control);
			dtCtrl.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.Control, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.ReagentType,typeof(string));
			dtCtrl.Columns.Add(TABLES.Reagent.LotNumber, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.VialId, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.IS,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.RT,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.C37,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.AHG,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlInterp, typeof(string));			
			dtCtrl.Columns.Add(ARTIFICIAL.ControlComment, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.SystemControlInterp, typeof(string));
			dtCtrl.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlReagentGuid, typeof(Guid));
			dtCtrl.Columns.Add(TABLES.Reagent.ReagentManufacturerName, typeof(string));
			dtCtrl.Columns.Add(TABLES.Reagent.LotExpirationDate, typeof(DateTime));
			dtCtrl.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.ISGuid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.RTGuid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.C37Guid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.AHGGuid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlInterpGuid, typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.ISRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.RTRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.C37RowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.AHGRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.CCRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.InterpRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlInterpSave, typeof(bool));
			dtCtrl.Columns.Add(TABLES.VamcDivision.DivisionCode, typeof(string));
			dtCtrl.Columns.Add(TABLES.RackLot.TestWithId, typeof(int));
			dtCtrl.Columns.Add(ARTIFICIAL.OverrideComment, typeof(string));
			//
			DataRow drPos = dtCtrl.NewRow();
			drPos[ARTIFICIAL.Indicator] = "";
			drPos[ARTIFICIAL.Control] = "POS";
			drPos[ARTIFICIAL.ReagentType] = dtReagents.Rows[1][TABLES.ReagentType.ReagentTypeId];
			drPos[TABLES.Reagent.LotNumber] = dtReagents.Rows[1][TABLES.Reagent.LotNumber];
			drPos[ARTIFICIAL.VialId] = "1";
			drPos[ARTIFICIAL.IS] = "2";
			drPos[ARTIFICIAL.C37] = "2";
			drPos[ARTIFICIAL.ControlInterp] = "P";
			drPos[ARTIFICIAL.ControlComment] = "Unit Testing";
			drPos[ARTIFICIAL.SystemControlInterp] = "P";
			drPos[TABLES.Reagent.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drPos[ARTIFICIAL.ControlReagentGuid] = dtReagents.Rows[1][TABLES.Reagent.ReagentGuid];
			drPos[TABLES.Reagent.ReagentManufacturerName] = dtReagents.Rows[1][TABLES.Reagent.ReagentManufacturerName].ToString();
			drPos[TABLES.Reagent.LotExpirationDate] = dtReagents.Rows[1][TABLES.Reagent.LotExpirationDate];
			drPos[TABLES.ReactivityPhase.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.ISand37).ToString();
			drPos[ARTIFICIAL.IndicatorMessage] = "";
			drPos[ARTIFICIAL.PartiallyCompleted] = false;
			drPos[ARTIFICIAL.ISGuid] = Guid.NewGuid();
			drPos[ARTIFICIAL.RTGuid] = Guid.Empty;
			drPos[ARTIFICIAL.C37Guid] = Guid.NewGuid();
			drPos[ARTIFICIAL.AHGGuid] = Guid.Empty;
			drPos[ARTIFICIAL.CCGuid] = Guid.Empty;
			drPos[ARTIFICIAL.ControlInterpGuid] = Guid.NewGuid();
			drPos[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.RTRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.ISSave] = true;
			drPos[ARTIFICIAL.RTSave] = false;
			drPos[ARTIFICIAL.C37Save] = true;
			drPos[ARTIFICIAL.AHGSave] = false;
			drPos[ARTIFICIAL.CCSave] = false;
			drPos[ARTIFICIAL.ControlInterpSave] = true;
			drPos[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drPos[TABLES.RackLot.TestWithId] = DBNull.Value;
			//
			dtCtrl.Rows.Add(drPos);
			//
			DataRow drNeg = dtCtrl.NewRow();
			drNeg[ARTIFICIAL.Indicator] = "";
			drNeg[ARTIFICIAL.Control] = "NEG";
			drNeg[ARTIFICIAL.ReagentType] = dtReagents.Rows[2][TABLES.ReagentType.ReagentTypeId];
			drNeg[TABLES.Reagent.LotNumber] = dtReagents.Rows[2][TABLES.Reagent.LotNumber];
			drNeg[ARTIFICIAL.VialId] = "0";
			drNeg[ARTIFICIAL.IS] = "0";
			drNeg[ARTIFICIAL.C37] = "2";
			drNeg[ARTIFICIAL.ControlInterp] = "N";
			drNeg[ARTIFICIAL.ControlComment] = "Unit Testing";
			drNeg[ARTIFICIAL.SystemControlInterp] = "N";
			drNeg[TABLES.Reagent.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drNeg[ARTIFICIAL.ControlReagentGuid] = dtReagents.Rows[2][TABLES.Reagent.ReagentGuid];
			drNeg[TABLES.Reagent.ReagentManufacturerName] = dtReagents.Rows[2][TABLES.Reagent.ReagentManufacturerName];
			drNeg[TABLES.Reagent.LotExpirationDate] = dtReagents.Rows[2][TABLES.Reagent.LotExpirationDate];
			drNeg[TABLES.ReactivityPhase.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.ISand37).ToString();
			drNeg[ARTIFICIAL.IndicatorMessage] = "";
			drNeg[ARTIFICIAL.PartiallyCompleted] = false;
			drNeg[ARTIFICIAL.ISGuid] = Guid.NewGuid();
			drNeg[ARTIFICIAL.RTGuid] = Guid.Empty;
			drNeg[ARTIFICIAL.C37Guid] = Guid.NewGuid();
			drNeg[ARTIFICIAL.AHGGuid] = Guid.Empty;
			drNeg[ARTIFICIAL.CCGuid] = Guid.Empty;
			drNeg[ARTIFICIAL.ControlInterpGuid] = Guid.NewGuid();
			drNeg[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.RTRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.ISSave] = true;
			drNeg[ARTIFICIAL.RTSave] = false;
			drNeg[ARTIFICIAL.C37Save] = true;
			drNeg[ARTIFICIAL.AHGSave] = false;
			drNeg[ARTIFICIAL.CCSave] = false;
			drNeg[ARTIFICIAL.ControlInterpSave] = true;
			drNeg[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drNeg[TABLES.RackLot.TestWithId] = DBNull.Value;
			drNeg[ARTIFICIAL.OverrideComment] = "Unit Test 7040";
			//
			dtCtrl.Rows.Add(drNeg);
			//
			foreach(DataRow result in dtWorklistQCResults.Rows)
			{
				string phase = result[TABLES.RackTest.RackTestResultTypeCode].ToString().Trim();
				//
				if ((bool)result[TABLES.RackLot.ControlCellId])
				{
					drPos[ARTIFICIAL.InterpRowVersion] = result[ARTIFICIAL.RackLotRowVersion];
					drPos[ARTIFICIAL.ControlInterpGuid] = result[TABLES.RackLot.RackLotGuid];
					drPos[TABLES.RackLot.TestWithId] = result[TABLES.RackLot.TestWithId];
					//
					if (phase == ARTIFICIAL.IS)
					{
						drPos[ARTIFICIAL.ISGuid] = result[TABLES.RackTest.RackTestGuid];
						drPos[ARTIFICIAL.ISRowVersion] = result[TABLES.RackTest.RowVersion];
					}
					else if (phase == ARTIFICIAL.C37)
					{
						drPos[ARTIFICIAL.C37Guid] = result[TABLES.RackTest.RackTestGuid];
						drPos[ARTIFICIAL.C37RowVersion] = result[TABLES.RackTest.RowVersion];
					}
				}
				else
				{
					drNeg[ARTIFICIAL.InterpRowVersion] = result[ARTIFICIAL.RackLotRowVersion];
					drNeg[ARTIFICIAL.ControlInterpGuid] = result[TABLES.RackLot.RackLotGuid];
					drNeg[TABLES.RackLot.TestWithId] = result[TABLES.RackLot.TestWithId];
					//
					//
					if (phase == ARTIFICIAL.IS)
					{
						drNeg[ARTIFICIAL.ISGuid] = result[TABLES.RackTest.RackTestGuid];
						drNeg[ARTIFICIAL.ISRowVersion] = result[TABLES.RackTest.RowVersion];
					}
					else if (phase == ARTIFICIAL.C37)
					{
						drNeg[ARTIFICIAL.C37Guid] = result[TABLES.RackTest.RackTestGuid];
						drNeg[ARTIFICIAL.C37RowVersion] = result[TABLES.RackTest.RowVersion];
					}
				}
				//
			}
			//
			//Finally, after setting up all that data, we can test the method!!!!!!!!! Nice!
			//
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UnitAntigenPhenotypingMultipleTestPhases);
			ArrayList workloadProcessIds = new ArrayList(1);
			workloadProcessIds.Add(Common.WorkloadProcessID.UnitAntigenPhenotypingMultipleTestPhases);
			workloadProcessIds.Add(Common.WorkloadProcessID.UnitAntigenPhenotypingMultipleTestPhases);
			bool retValue = BOL.BloodUnitTest.SaveAntigenTypingBloodUnitTests((Guid)drRackLot[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid],tmpAW,dtAGC,dtCtrl, Convert.ToInt32(Common.ReactivityPhase.ISand37).ToString(), Common.UpdateFunction.UC041FrmRecordPhenotypeResults, workloadProcessIds, buGuids, false);  
			//
			Assert.IsTrue(retValue);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void SaveAntigenTypingBloodUnitTests_Fail()
		{
			//
			//This test will fail due to rowversions not being set when trying to update!
			//
			Guid buGuid = (Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			Guid[] buGuids = new Guid[] {buGuid};
			Guid rackGuid = (Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			//
			//Create new Anti-E reagent to test against.
			DataTable dtReagents = Reagent.InitializeReagentsAndManufacturersTable();
			DataRow drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = Guid.NewGuid();
			drReagent[TABLES.ReagentType.ReagentTypeId] = 12; //Anti-E
			drReagent["ReagentName"] = "Test E Reagent";
			drReagent["ReceiptDate"] = DateTime.Now;
			drReagent["ReceiptTechId"] = UnitTestConfig.User_Technologist;
			drReagent["InvoiceNumber"] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "E"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent["NumberVialsReceived"] = 20;
			drReagent["NumberVialsAvailable"] = 15;
			drReagent["Comments"] = "Unit Test 1706";
			drReagent["InspectionIndicator"] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent["ReagentTypeName"] = "Anti-E";
			drReagent[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drReagent["RecordStatusCode"] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Insert new reagent
			BOL.Reagent.InsertNewReagent(dtReagents, BOL.ReagentType.GetReagentTypes(), Common.UpdateFunction.UnitTests);
			//
			//Create new antisera worklist
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(Guid.NewGuid());
			tmpAW.TestingMethodCode = Common.TestingMethod.Gel;
			tmpAW.WorklistCreateDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			tmpAW.WorklistName = Environment.UserName;
			//
			DataTable tmpAWT = new DataTable();
			tmpAWT.Columns.Add("AntiseraWorklistTypingGuid", typeof(Guid));
			tmpAWT.Columns.Add(TABLES.AntiseraWorklist.AntiseraWorklistGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.ReagentGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.RackGuid,typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.ReactivityPhaseCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.Comments,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.DivisionCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.TestWithId,typeof(int));
			tmpAWT.Columns.Add("RackQCOverrideComment",typeof(string));
			tmpAWT.Columns.Add("ExpiredOverrideComment",typeof(string));
			tmpAWT.Columns.Add("PhaseOverrideComment",typeof(string));
			//
			DataRow drAWT = tmpAWT.NewRow();
			drAWT[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid] = Guid.NewGuid();
			drAWT[TABLES.AntiseraWorklist.AntiseraWorklistGuid] = tmpAW.AntiseraWorklistGuid;
			drAWT[TABLES.OrderableTest.OrderableTestId] = Convert.ToInt32(Common.OrderableTest.AGC).ToString();
			drAWT[TABLES.RackLot.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drAWT[TABLES.RackLot.RackGuid] = rackGuid;
			drAWT[TABLES.RackLot.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.AHGandCC).ToString();
			drAWT[TABLES.RackLot.Comments] = "";
			drAWT[TABLES.RackLot.DivisionCode] = this.TestDivisionCode;
			tmpAWT.Rows.Add(drAWT);
			//
			//Create AGC grid table
			DataTable dtAGC = new DataTable("Phenotype");
			//
			dtAGC.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtAGC.Columns.Add(TABLES.ExceptionUnitIssue.UnitId, typeof(string));
			dtAGC.Columns.Add(TABLES.BloodProduct.ProductName, typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.IS,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.RT,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.C37,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.AHG,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.Interp, typeof(string));			
			dtAGC.Columns.Add(ARTIFICIAL.Comment, typeof(string));
			dtAGC.Columns.Add(TABLES.ValidRhResult.SystemInterp, typeof(string));
			dtAGC.Columns.Add(TABLES.BloodUnit.BloodUnitGuid, typeof(Guid));
			dtAGC.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dtAGC.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(string));
			dtAGC.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.ISGuid,typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.RTGuid,typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.C37Guid,typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.AHGGuid,typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.InterpGuid, typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.ISRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.RTRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.C37RowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.AHGRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.CCRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.InterpRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.InterpSave, typeof(bool));
			dtAGC.Columns.Add(TABLES.BloodUnitStatus.QuarantineIndicator, typeof(bool));
			dtAGC.Columns.Add(TABLES.VamcDivision.DivisionCode, typeof(string));
			dtAGC.Columns.Add(TABLES.ExceptionQc.ExceptionComment, typeof(string));
			//
			DataRow dr = dtAGC.NewRow();
			dr[ARTIFICIAL.Indicator] = "";
			dr[TABLES.ExceptionUnitIssue.UnitId] = this._dtBloodUnit.Rows[0][TABLES.BloodUnit.EyeReadableUnitId];
			dr[TABLES.BloodProduct.ProductName] = this._dtBloodUnit.Rows[0][TABLES.BloodProduct.ProductShortName];
			dr[ARTIFICIAL.AHG] = "4";
			dr[ARTIFICIAL.CC] = "4";
			dr[ARTIFICIAL.Interp] = "P";
			dr[ARTIFICIAL.Comment] = "Unit Testing";
			dr[TABLES.ValidRhResult.SystemInterp] = "P";
			dr[TABLES.BloodUnit.BloodUnitGuid] = this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			dr[TABLES.Reagent.ReagentGuid] = drReagent[TABLES.Reagent.ReagentGuid];
			dr[TABLES.ReactivityPhase.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.AHGandCC).ToString();
			dr[TABLES.OrderableTest.OrderableTestId] = Convert.ToInt32(Common.OrderableTest.AGC);
			dr[ARTIFICIAL.IndicatorMessage] = "";
			dr[ARTIFICIAL.PartiallyCompleted] = false;
			dr[ARTIFICIAL.ISGuid] = Guid.Empty;
			dr[ARTIFICIAL.RTGuid] = Guid.Empty;
			dr[ARTIFICIAL.C37Guid] = Guid.Empty;
			dr[ARTIFICIAL.AHGGuid] = Guid.Empty;
			dr[ARTIFICIAL.CCGuid] = Guid.Empty;
			dr[ARTIFICIAL.InterpGuid] = Guid.Empty;
			dr[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.RTRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			dr[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.ISSave] = false;
			dr[ARTIFICIAL.RTSave] = false;
			dr[ARTIFICIAL.C37Save] = false;
			dr[ARTIFICIAL.AHGSave] = true;
			dr[ARTIFICIAL.CCSave] = true;
			dr[ARTIFICIAL.InterpSave] = true;
			dr[TABLES.BloodUnitStatus.QuarantineIndicator] = false;
			dr[TABLES.ExceptionQc.ExceptionComment] = DBNull.Value;
			//
			dtAGC.Rows.Add(dr);
			//
			//Now create control table
			//
			DataTable dtCtrl = new DataTable(ARTIFICIAL.Control);
			dtCtrl.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.Control, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.ReagentType,typeof(string));
			dtCtrl.Columns.Add(TABLES.Reagent.LotNumber, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.VialId, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.IS,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.RT,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.C37,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.AHG,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlInterp, typeof(string));			
			dtCtrl.Columns.Add(ARTIFICIAL.ControlComment, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.SystemControlInterp, typeof(string));
			dtCtrl.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlReagentGuid, typeof(Guid));
			dtCtrl.Columns.Add(TABLES.Reagent.ReagentManufacturerName, typeof(string));
			dtCtrl.Columns.Add(TABLES.Reagent.LotExpirationDate, typeof(DateTime));
			dtCtrl.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.ISGuid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.RTGuid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.C37Guid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.AHGGuid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlInterpGuid, typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.ISRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.RTRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.C37RowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.AHGRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.CCRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.InterpRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlInterpSave, typeof(bool));
			dtCtrl.Columns.Add(TABLES.VamcDivision.DivisionCode, typeof(string));
			dtCtrl.Columns.Add(TABLES.RackLot.TestWithId, typeof(int));
			dtCtrl.Columns.Add(ARTIFICIAL.OverrideComment, typeof(string));
			//
			DataRow drPos = dtCtrl.NewRow();
			drPos[ARTIFICIAL.Indicator] = "";
			drPos[ARTIFICIAL.Control] = "POS";
			drPos[ARTIFICIAL.ReagentType] = drReagent[TABLES.ReagentType.ReagentTypeId];
			drPos[TABLES.Reagent.LotNumber] = drReagent[TABLES.Reagent.LotNumber];
			drPos[ARTIFICIAL.VialId] = "1";
			drPos[ARTIFICIAL.AHG] = "2";
			drPos[ARTIFICIAL.CC] = "2";
			drPos[ARTIFICIAL.ControlInterp] = "P";
			drPos[ARTIFICIAL.ControlComment] = "Unit Testing";
			drPos[ARTIFICIAL.SystemControlInterp] = "P";
			drPos[TABLES.Reagent.ReagentGuid] = drReagent[TABLES.Reagent.ReagentGuid];
			drPos[ARTIFICIAL.ControlReagentGuid] = drReagent[TABLES.Reagent.ReagentGuid];
			drPos[TABLES.Reagent.ReagentManufacturerName] = drReagent[TABLES.Reagent.ReagentManufacturerName].ToString();
			drPos[TABLES.Reagent.LotExpirationDate] = drReagent[TABLES.Reagent.LotExpirationDate];
			drPos[TABLES.ReactivityPhase.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.AHGandCC).ToString();
			drPos[ARTIFICIAL.IndicatorMessage] = "";
			drPos[ARTIFICIAL.PartiallyCompleted] = false;
			drPos[ARTIFICIAL.ISGuid] = Guid.Empty;
			drPos[ARTIFICIAL.RTGuid] = Guid.Empty;
			drPos[ARTIFICIAL.C37Guid] = Guid.Empty;
			drPos[ARTIFICIAL.AHGGuid] = Guid.NewGuid();
			drPos[ARTIFICIAL.CCGuid] = Guid.NewGuid();
			drPos[ARTIFICIAL.ControlInterpGuid] = Guid.NewGuid();
			drPos[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.RTRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.ISSave] = false;
			drPos[ARTIFICIAL.RTSave] = false;
			drPos[ARTIFICIAL.C37Save] = false;
			drPos[ARTIFICIAL.AHGSave] = true;
			drPos[ARTIFICIAL.CCSave] = true;
			drPos[ARTIFICIAL.ControlInterpSave] = true;
			drPos[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drPos[TABLES.RackLot.TestWithId] = DBNull.Value;
			drPos[ARTIFICIAL.OverrideComment] = DBNull.Value;
			//
			dtCtrl.Rows.Add(drPos);
			//
			DataRow drNeg = dtCtrl.NewRow();
			drNeg[ARTIFICIAL.Indicator] = "";
			drNeg[ARTIFICIAL.Control] = "NEG";
			drNeg[ARTIFICIAL.ReagentType] = drReagent[TABLES.ReagentType.ReagentTypeId];
			drNeg[TABLES.Reagent.LotNumber] = drReagent[TABLES.Reagent.LotNumber];
			drNeg[ARTIFICIAL.VialId] = "0";
			drNeg[ARTIFICIAL.AHG] = "0";
			drNeg[ARTIFICIAL.CC] = "2";
			drNeg[ARTIFICIAL.ControlInterp] = "N";
			drNeg[ARTIFICIAL.ControlComment] = "Unit Testing";
			drNeg[ARTIFICIAL.SystemControlInterp] = "N";
			drNeg[TABLES.Reagent.ReagentGuid] = drReagent[TABLES.Reagent.ReagentGuid];
			drNeg[ARTIFICIAL.ControlReagentGuid] = drReagent[TABLES.Reagent.ReagentGuid];
			drNeg[TABLES.Reagent.ReagentManufacturerName] = drReagent[TABLES.Reagent.ReagentManufacturerName];
			drNeg[TABLES.Reagent.LotExpirationDate] = drReagent[TABLES.Reagent.LotExpirationDate];
			drNeg[TABLES.ReactivityPhase.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.AHGandCC).ToString();
			drNeg[ARTIFICIAL.IndicatorMessage] = "";
			drNeg[ARTIFICIAL.PartiallyCompleted] = false;
			drNeg[ARTIFICIAL.ISGuid] = Guid.Empty;
			drNeg[ARTIFICIAL.RTGuid] = Guid.Empty;
			drNeg[ARTIFICIAL.C37Guid] = Guid.Empty;
			drNeg[ARTIFICIAL.AHGGuid] = Guid.NewGuid();
			drNeg[ARTIFICIAL.CCGuid] = Guid.NewGuid();
			drNeg[ARTIFICIAL.ControlInterpGuid] = Guid.NewGuid();
			drNeg[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.RTRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.ISSave] = false;
			drNeg[ARTIFICIAL.RTSave] = false;
			drNeg[ARTIFICIAL.C37Save] = false;
			drNeg[ARTIFICIAL.AHGSave] = true;
			drNeg[ARTIFICIAL.CCSave] = true;
			drNeg[ARTIFICIAL.ControlInterpSave] = true;
			drNeg[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drNeg[TABLES.RackLot.TestWithId] = DBNull.Value;
			drNeg[ARTIFICIAL.OverrideComment] = DBNull.Value;
			//
			dtCtrl.Rows.Add(drNeg);
			//
			//Attempt to save details
			ArrayList workloadProcessIds = new ArrayList(1);
			workloadProcessIds.Add(Common.WorkloadProcessID.Unknown);
			bool retValue = BOL.BloodUnitTest.SaveAntigenTypingBloodUnitTests((Guid)tmpAWT.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid],tmpAW,dtAGC,dtCtrl, Convert.ToInt32(Common.ReactivityPhase.AHGandCC).ToString(), Common.UpdateFunction.UC041FrmRecordPhenotypeResults, workloadProcessIds, buGuids, false);
			//
			Assert.IsTrue(!retValue);
		}

		[Test]
		public void SaveWeakDBloodUnitTests_Pass()
		{
			//
			//For 100% coverage, we must issue a unit first!
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}
			//
			Guid bloodUnitGuid = Guid.NewGuid();
			//
			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			Guid bloodProductGuid = (Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);
			DataTable dtUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE BloodunitGuid = '"+ bloodUnitGuid.ToString()+"'");
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedComponentGuid = Guid.NewGuid();
			string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
			insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
			insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
			insertOrderedComponent += "VALUES (";
			insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedComponent += "'1',";
            insertOrderedComponent += "'" + SprocHelper.GetNewCprsOrderNumber() + "',";
			insertOrderedComponent += "'2',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'I',";
			insertOrderedComponent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'" + Environment.UserName + "',";
			insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedUnitGuid = Guid.NewGuid();
			string insertOrderedUnit = "INSERT INTO ORDEREDUNIT (";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedComponentGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.BloodUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchRequiredIndicator + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchResultCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchTechId + ",";
			insertOrderedUnit += TABLES.OrderedUnit.RecordStatusCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.DivisionCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateUser + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateFunctionId + ")";
			insertOrderedUnit += "VALUES (";
			insertOrderedUnit += "'" + orderedUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedUnit += "'" + bloodUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "1,";
			insertOrderedUnit += "'C',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'A',";
			insertOrderedUnit += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			string insertBloodUnitTest1 = "INSERT INTO BLOODUNITTEST (";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.BloodUnitTestGuid + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.BloodUnitGuid + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.BloodTestTypeId + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.TestDate + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.TestTechId + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.TestResultId + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.EntryTechId + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.EntryMethodCode + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.OrderedComponentGuid + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.OrderedUnitGuid + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.ReactivityPhaseCode + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.RecordStatusCode + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.DivisionCode + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.LastUpdateDate + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.LastUpdateUser + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.LastUpdateFunctionId + ")";
			insertBloodUnitTest1 += "VALUES (";
			insertBloodUnitTest1 += "'" + bloodUnitTestGuid1.ToString() + "',";
			insertBloodUnitTest1 += "'" + bloodUnitGuid.ToString() + "',";
			insertBloodUnitTest1 += "'100',";
			insertBloodUnitTest1 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest1 += "'" + Environment.UserName + "',";
			insertBloodUnitTest1 += "'0',";
			insertBloodUnitTest1 += "'" + Environment.UserName + "',";
			insertBloodUnitTest1 += "'M',";
			insertBloodUnitTest1 += "'" + orderedComponentGuid.ToString() + "',";
			insertBloodUnitTest1 += "'" + orderedUnitGuid.ToString() + "',";
			insertBloodUnitTest1 += "'2',";
			insertBloodUnitTest1 += "'A',";
			insertBloodUnitTest1 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertBloodUnitTest1 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest1 += "'" + Environment.UserName + "',";
			insertBloodUnitTest1 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			string insertBloodUnitTest2 = "INSERT INTO BLOODUNITTEST (";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.BloodUnitTestGuid + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.BloodUnitGuid + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.BloodTestTypeId + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.TestDate + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.TestTechId + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.TestResultId + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.EntryTechId + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.EntryMethodCode + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.OrderedComponentGuid + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.OrderedUnitGuid + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.ReactivityPhaseCode + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.RecordStatusCode + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.DivisionCode + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.LastUpdateDate + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.LastUpdateUser + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.LastUpdateFunctionId + ")";
			insertBloodUnitTest2 += "VALUES (";
			insertBloodUnitTest2 += "'" + bloodUnitTestGuid2.ToString() + "',";
			insertBloodUnitTest2 += "'" + bloodUnitGuid.ToString() + "',";
			insertBloodUnitTest2 += "'102',";
			insertBloodUnitTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest2 += "'" + Environment.UserName + "',";
			insertBloodUnitTest2 += "'C',";
			insertBloodUnitTest2 += "'" + Environment.UserName + "',";
			insertBloodUnitTest2 += "'M',";
			insertBloodUnitTest2 += "'" + orderedComponentGuid.ToString() + "',";
			insertBloodUnitTest2 += "'" + orderedUnitGuid.ToString() + "',";
			insertBloodUnitTest2 += "'2',";
			insertBloodUnitTest2 += "'A',";
			insertBloodUnitTest2 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertBloodUnitTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest2 += "'" + Environment.UserName + "',";
			insertBloodUnitTest2 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid issuedUnitGuid = Guid.NewGuid();
			string insertIssuedUnit = "INSERT INTO ISSUEDUNIT (";
			insertIssuedUnit += TABLES.IssuedUnit.IssuedUnitGuid + ",";
			insertIssuedUnit += TABLES.IssuedUnit.BloodUnitGuid + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueDateTime + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueTechId + ",";
			insertIssuedUnit += TABLES.IssuedUnit.TransporterName + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueToLocationName + ",";
			insertIssuedUnit += TABLES.IssuedUnit.InPatientLocationIndicator + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueSatisfactoryIndicator + ",";
			insertIssuedUnit += TABLES.IssuedUnit.RemoteStorageIndicator + ",";
			insertIssuedUnit += TABLES.IssuedUnit.LastUpdateDate + ",";
			insertIssuedUnit += TABLES.IssuedUnit.LastUpdateUser + ",";
			insertIssuedUnit += TABLES.IssuedUnit.LastUpdateFunctionId + ")";
			insertIssuedUnit += "VALUES (";
			insertIssuedUnit += "'" + issuedUnitGuid.ToString() + "',";
			insertIssuedUnit += "'" + bloodUnitGuid.ToString() + "',";
			insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertIssuedUnit += "'" + Environment.UserName + "',";
			insertIssuedUnit += "'" + Environment.UserName + "',";
			insertIssuedUnit += "'10W P-KC',";
			insertIssuedUnit += "0,";
			insertIssuedUnit += "1,";
			insertIssuedUnit += "0,";
			insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertIssuedUnit += "'" + Environment.UserName + "',";
			insertIssuedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

//			string updateBloodUnitStatus = "UPDATE BloodUnitStatus SET ";
//			updateBloodUnitStatus += TABLES.BloodUnitStatus.UnitStatusCode + " = '" + Common.Utility.GetUnitStatusCodeCharFromEnum(Common.UnitStatusCode.Issued).ToString() + "' ";
//			updateBloodUnitStatus += "WHERE " + TABLES.BloodUnit.BloodUnitGuid + " = '" + bloodUnitGuid.ToString() + "'";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedComponent);
			UnitTestUtil.RunSQL(insertOrderedUnit);
			UnitTestUtil.RunSQL(insertBloodUnitTest1);
			UnitTestUtil.RunSQL(insertBloodUnitTest2);
			UnitTestUtil.RunSQL(insertIssuedUnit);
//			UnitTestUtil.RunSQL(updateBloodUnitStatus);
			//
			//Create new Anti-D reagent to test against.
			DataTable dtReagents = Reagent.InitializeReagentsAndManufacturersTable();
			DataRow drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = Guid.NewGuid();
			drReagent[TABLES.ReagentType.ReagentTypeId] = 52; //Anti-D
			drReagent["ReagentName"] = "Test D Reagent";
			drReagent["ReceiptDate"] = DateTime.Now;
			drReagent["ReceiptTechId"] = UnitTestConfig.User_Technologist;
			drReagent["InvoiceNumber"] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "D"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent["NumberVialsReceived"] = 20;
			drReagent["NumberVialsAvailable"] = 15;
			drReagent["Comments"] = "Unit Test 1708";
			drReagent["InspectionIndicator"] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent["ReagentTypeName"] = "Anti-D";
			drReagent[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drReagent["RecordStatusCode"] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Create new Anti-Dc reagent to for Pos control.
			Guid antiDcGuid = Guid.NewGuid();
			drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = antiDcGuid;
			drReagent[TABLES.ReagentType.ReagentTypeId] = 53; //Screening Cells
			drReagent["ReagentName"] = "Test Dc Reagent";
			drReagent["ReceiptDate"] = DateTime.Now;
			drReagent["ReceiptTechId"] = UnitTestConfig.User_Technologist;
			drReagent["InvoiceNumber"] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "Dc"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent["NumberVialsReceived"] = 20;
			drReagent["NumberVialsAvailable"] = 15;
			drReagent["Comments"] = "Unit Test 1708";
			drReagent["InspectionIndicator"] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent["ReagentTypeName"] = "Anti-D Control";
			drReagent[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drReagent["RecordStatusCode"] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Insert new reagents
			BOL.Reagent.InsertNewReagent(dtReagents, BOL.ReagentType.GetReagentTypes(), Common.UpdateFunction.UnitTests);
			//
			Guid buGuid = bloodUnitGuid;
			Guid[] buGuids = new Guid[] {buGuid};
			Guid rackGuid = (Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			//
			//Now we will insert a new antisera worklist
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(Guid.NewGuid());
			tmpAW.TestingMethodCode = Common.TestingMethod.Gel;
			tmpAW.WorklistCreateDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			tmpAW.WorklistName = Environment.UserName;
			//
			DataTable tmpAWT = new DataTable();
			tmpAWT.Columns.Add("AntiseraWorklistTypingGuid", typeof(Guid));
			tmpAWT.Columns.Add(TABLES.AntiseraWorklist.AntiseraWorklistGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.ReagentGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.RackGuid,typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.ReactivityPhaseCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.Comments,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.DivisionCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.TestWithId,typeof(int));
			tmpAWT.Columns.Add("RackQCOverrideComment",typeof(string));
			tmpAWT.Columns.Add("ExpiredOverrideComment",typeof(string));
			tmpAWT.Columns.Add("PhaseOverrideComment",typeof(string));
			//
			DataRow drAWT = tmpAWT.NewRow();
			drAWT[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid] = Guid.NewGuid();
			drAWT[TABLES.AntiseraWorklist.AntiseraWorklistGuid] = tmpAW.AntiseraWorklistGuid;
			drAWT[TABLES.OrderableTest.OrderableTestId] = Convert.ToInt32(Common.OrderableTest.AGwD).ToString();
			drAWT[TABLES.RackLot.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drAWT[TABLES.RackLot.RackGuid] = rackGuid;
			drAWT[TABLES.RackLot.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.ThreeSevenandAHG).ToString();
			drAWT[TABLES.RackLot.Comments] = "";
			drAWT[TABLES.RackLot.DivisionCode] = this.TestDivisionCode;
			drAWT["RackQCOverrideComment"] = "Unit Test 1708";
			drAWT["ExpiredOverrideComment"] = "Unit Test 1708";
			drAWT["PhaseOverrideComment"] = "Unit Test 1708";
			tmpAWT.Rows.Add(drAWT);
			//
			//Save the antisera worklist
			tmpAW.Save(tmpAWT,dtUnit,Environment.UserName,Common.UpdateFunction.UnitTests,new Guid[] {buGuid}, antiDcGuid,"", false);
			//
			//Now we need to load the saved antisera worklist, complete the tests and save again.
			BOL.AntiseraWorklist aw = new BOL.AntiseraWorklist(tmpAW.AntiseraWorklistGuid);
			DataTable dtAWT = BOL.AntiseraWorklist.GetAntiseraWorklistDetails(tmpAW.AntiseraWorklistGuid);
			DataTable dtUnits = BOL.AntiseraWorklist.GetAntiseraWorklistUnits(tmpAW.AntiseraWorklistGuid);
			//
			DataRow drRackLot = dtAWT.Rows[0];
			DataRow drUnit = dtUnits.Rows[0];
			DataRow drDReagent = dtReagents.Rows[0];
			DataRow drDcReagent = dtReagents.Rows[1];
			//
			//Now create WeakD grid table
			DataTable dtWD = new DataTable("WeakD");
			//
			dtWD.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtWD.Columns.Add(TABLES.ExceptionUnitIssue.UnitId, typeof(string));
			dtWD.Columns.Add(TABLES.BloodProduct.ProductName, typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.D37,typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.Dc37,typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.DAHG,typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.DcAHG,typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.DCC, typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.DcCC, typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.Interp, typeof(string));			
			dtWD.Columns.Add(ARTIFICIAL.Comment, typeof(string));
			dtWD.Columns.Add(TABLES.ValidRhResult.SystemInterp, typeof(string));
			dtWD.Columns.Add(TABLES.BloodUnit.BloodUnitGuid, typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.AntiDReagentGuid, typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.DControlReagentGuid, typeof(Guid));
			dtWD.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(string));
			dtWD.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.D37Guid,typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.Dc37Guid,typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.DAHGGuid,typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.DcAHGGuid,typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.DCCGuid, typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.DcCCGuid, typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.InterpGuid, typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.D37RowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.Dc37RowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.DAHGRowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.DcAHGRowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.DCCRowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.DcCCRowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.InterpRowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.D37Save, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.Dc37Save, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.DAHGSave, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.DcAHGSave, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.DCCSave, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.DcCCSave, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.InterpSave, typeof(bool));
			dtWD.Columns.Add(TABLES.BloodUnitStatus.QuarantineIndicator, typeof(bool));
			dtWD.Columns.Add(TABLES.VamcDivision.DivisionCode, typeof(string));
			dtWD.Columns.Add(TABLES.Rack.RackGuid, typeof(Guid));
			dtWD.Columns.Add(TABLES.ExceptionQc.ExceptionComment, typeof(string));
			//
			DataRow dr = dtWD.NewRow();
			dr[ARTIFICIAL.Indicator] = "";
			dr[TABLES.ExceptionUnitIssue.UnitId] = drUnit[TABLES.BloodUnit.EyeReadableUnitId];
			dr[TABLES.BloodProduct.ProductName] = drUnit[TABLES.BloodProduct.ProductShortName];
			dr[ARTIFICIAL.D37] = "4";
			dr[ARTIFICIAL.Dc37] = "0";
			dr[ARTIFICIAL.DAHG] = "4";
			dr[ARTIFICIAL.DcAHG] = "0";
			dr[ARTIFICIAL.DCC] = "4";
			dr[ARTIFICIAL.DcCC] = "4";
			dr[ARTIFICIAL.Interp] = "P";
			dr[ARTIFICIAL.Comment] = "Unit Testing";
			dr[TABLES.ValidRhResult.SystemInterp] = "P";
			dr[TABLES.BloodUnit.BloodUnitGuid] = drUnit[TABLES.BloodUnit.BloodUnitGuid];
			dr[ARTIFICIAL.AntiDReagentGuid] = drDReagent[TABLES.Reagent.ReagentGuid];
			dr[ARTIFICIAL.DControlReagentGuid] = drDcReagent[TABLES.Reagent.ReagentGuid];
			dr[TABLES.ReactivityPhase.ReactivityPhaseCode] = drRackLot[TABLES.ReactivityPhase.ReactivityPhaseCode];
			dr[TABLES.OrderableTest.OrderableTestId] = drRackLot[TABLES.OrderableTest.OrderableTestId];
			dr[ARTIFICIAL.IndicatorMessage] = "";
			dr[ARTIFICIAL.PartiallyCompleted] = false;
			dr[ARTIFICIAL.D37Guid] = Guid.Empty;
			dr[ARTIFICIAL.Dc37Guid] = Guid.Empty;
			dr[ARTIFICIAL.DAHGGuid] = Guid.Empty;
			dr[ARTIFICIAL.DcAHGGuid] = Guid.Empty;
			dr[ARTIFICIAL.DCCGuid] = Guid.Empty;
			dr[ARTIFICIAL.DcCCGuid] = Guid.Empty;
			dr[ARTIFICIAL.InterpGuid] = Guid.Empty;
			dr[ARTIFICIAL.D37RowVersion] = DBNull.Value;
			dr[ARTIFICIAL.Dc37RowVersion] = DBNull.Value;
			dr[ARTIFICIAL.DAHGRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.DcAHGRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.DCCRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.DcCCRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.D37Save] = true;
			dr[ARTIFICIAL.Dc37Save] = true;
			dr[ARTIFICIAL.DAHGSave] = true;
			dr[ARTIFICIAL.DcAHGSave] = true;
			dr[ARTIFICIAL.DCCSave] = true;
			dr[ARTIFICIAL.DcCCSave] = true;
			dr[ARTIFICIAL.InterpSave] = true;
			dr[TABLES.BloodUnitStatus.QuarantineIndicator] = true;
			dr[TABLES.VamcDivision.DivisionCode] = drRackLot[TABLES.RackLot.DivisionCode].ToString();
			dr[TABLES.Rack.RackGuid] = drRackLot[TABLES.RackLot.RackGuid];
			dr[TABLES.ExceptionQc.ExceptionComment] = "Unit Test 1708";
			//
			DataTable results = BOL.AntiseraWorklist.GetTestResultsForAntiseraWorklist((Guid)drUnit[TABLES.BloodUnit.BloodUnitGuid],(Guid)drRackLot["AntiseraWorklistTypingGuid"]);
			//
			DataTable testTypes = BOL.BloodTestType.GetBloodTestTypes(drRackLot[TABLES.OrderableTest.OrderableTestId].ToString());
			//
			foreach(DataRow result in results.Rows)
			{
				DataRow[] relevantTest = testTypes.Select(TABLES.BloodTestType.BloodTestTypeId+" = '" + result[TABLES.BloodTestType.BloodTestTypeId].ToString() + "'");
				if (relevantTest.Length >0)
				{
					string bloodTestType = relevantTest[0][TABLES.BloodTestType.BloodTestName].ToString();
					if (bloodTestType.IndexOf("wD 37") > -1)
					{
						dr[ARTIFICIAL.D37Guid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.D37RowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf("D Control 37") > -1)
					{
						dr[ARTIFICIAL.Dc37Guid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.Dc37RowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf("wD AHG") > -1)
					{
						dr[ARTIFICIAL.DAHGGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.DAHGRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf("D Control AHG") > -1)
					{
						dr[ARTIFICIAL.DcAHGGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.DcAHGRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf("wD CC") > -1)
					{
						dr[ARTIFICIAL.DCCGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.DCCRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf("D Control CC") > -1)
					{
						dr[ARTIFICIAL.DcCCGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.DcCCRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf(ARTIFICIAL.Interp) > -1)
					{
						dr[ARTIFICIAL.InterpGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.InterpRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
				}
			}
			//
			dtWD.Rows.Add(dr);
			//
			//Finally, after setting up all that data, we can test the method!!!!!!!!! Nice!
			//
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.AntigenPhenotypingMultipleTestPhasesQC);
			ArrayList workloadProcessIds = new ArrayList(1);
			workloadProcessIds.Add(Common.WorkloadProcessID.Unknown);
			workloadProcessIds.Add(Common.WorkloadProcessID.AntigenPhenotypingMultipleTestPhasesQC);
			bool retValue = BOL.BloodUnitTest.SaveWeakDBloodUnitTests((Guid)drRackLot[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid],tmpAW,dtWD, Common.UpdateFunction.UC041FrmRecordPhenotypeResults, workloadProcessIds, buGuids);  
			//
			Assert.IsTrue(retValue);
		}

		[Test]
		public void SaveWeakDBloodUnitTests2_Pass()
		{
			//
			//For 100% coverage, we must issue a unit first!
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}
			//
			Guid bloodUnitGuid = Guid.NewGuid();
			//
			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			Guid bloodProductGuid = (Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);
			DataTable dtUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE BloodunitGuid = '"+ bloodUnitGuid.ToString()+"'");
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedComponentGuid = Guid.NewGuid();
			string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
			insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
			insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
			insertOrderedComponent += "VALUES (";
			insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedComponent += "'1',";
            insertOrderedComponent += "'" + SprocHelper.GetNewCprsOrderNumber() + "',";
			insertOrderedComponent += "'2',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'I',";
			insertOrderedComponent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'" + Environment.UserName + "',";
			insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedUnitGuid = Guid.NewGuid();
			string insertOrderedUnit = "INSERT INTO ORDEREDUNIT (";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedComponentGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.BloodUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchRequiredIndicator + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchResultCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchTechId + ",";
			insertOrderedUnit += TABLES.OrderedUnit.RecordStatusCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.DivisionCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateUser + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateFunctionId + ")";
			insertOrderedUnit += "VALUES (";
			insertOrderedUnit += "'" + orderedUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedUnit += "'" + bloodUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "1,";
			insertOrderedUnit += "'C',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'A',";
			insertOrderedUnit += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			string insertBloodUnitTest1 = "INSERT INTO BLOODUNITTEST (";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.BloodUnitTestGuid + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.BloodUnitGuid + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.BloodTestTypeId + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.TestDate + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.TestTechId + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.TestResultId + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.EntryTechId + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.EntryMethodCode + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.OrderedComponentGuid + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.OrderedUnitGuid + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.ReactivityPhaseCode + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.RecordStatusCode + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.DivisionCode + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.LastUpdateDate + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.LastUpdateUser + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.LastUpdateFunctionId + ")";
			insertBloodUnitTest1 += "VALUES (";
			insertBloodUnitTest1 += "'" + bloodUnitTestGuid1.ToString() + "',";
			insertBloodUnitTest1 += "'" + bloodUnitGuid.ToString() + "',";
			insertBloodUnitTest1 += "'100',";
			insertBloodUnitTest1 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest1 += "'" + Environment.UserName + "',";
			insertBloodUnitTest1 += "'0',";
			insertBloodUnitTest1 += "'" + Environment.UserName + "',";
			insertBloodUnitTest1 += "'M',";
			insertBloodUnitTest1 += "'" + orderedComponentGuid.ToString() + "',";
			insertBloodUnitTest1 += "'" + orderedUnitGuid.ToString() + "',";
			insertBloodUnitTest1 += "'2',";
			insertBloodUnitTest1 += "'A',";
			insertBloodUnitTest1 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertBloodUnitTest1 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest1 += "'" + Environment.UserName + "',";
			insertBloodUnitTest1 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			string insertBloodUnitTest2 = "INSERT INTO BLOODUNITTEST (";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.BloodUnitTestGuid + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.BloodUnitGuid + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.BloodTestTypeId + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.TestDate + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.TestTechId + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.TestResultId + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.EntryTechId + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.EntryMethodCode + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.OrderedComponentGuid + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.OrderedUnitGuid + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.ReactivityPhaseCode + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.RecordStatusCode + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.DivisionCode + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.LastUpdateDate + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.LastUpdateUser + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.LastUpdateFunctionId + ")";
			insertBloodUnitTest2 += "VALUES (";
			insertBloodUnitTest2 += "'" + bloodUnitTestGuid2.ToString() + "',";
			insertBloodUnitTest2 += "'" + bloodUnitGuid.ToString() + "',";
			insertBloodUnitTest2 += "'102',";
			insertBloodUnitTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest2 += "'" + Environment.UserName + "',";
			insertBloodUnitTest2 += "'C',";
			insertBloodUnitTest2 += "'" + Environment.UserName + "',";
			insertBloodUnitTest2 += "'M',";
			insertBloodUnitTest2 += "'" + orderedComponentGuid.ToString() + "',";
			insertBloodUnitTest2 += "'" + orderedUnitGuid.ToString() + "',";
			insertBloodUnitTest2 += "'2',";
			insertBloodUnitTest2 += "'A',";
			insertBloodUnitTest2 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertBloodUnitTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest2 += "'" + Environment.UserName + "',";
			insertBloodUnitTest2 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid issuedUnitGuid = Guid.NewGuid();
			string insertIssuedUnit = "INSERT INTO ISSUEDUNIT (";
			insertIssuedUnit += TABLES.IssuedUnit.IssuedUnitGuid + ",";
			insertIssuedUnit += TABLES.IssuedUnit.BloodUnitGuid + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueDateTime + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueTechId + ",";
			insertIssuedUnit += TABLES.IssuedUnit.TransporterName + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueToLocationName + ",";
			insertIssuedUnit += TABLES.IssuedUnit.InPatientLocationIndicator + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueSatisfactoryIndicator + ",";
			insertIssuedUnit += TABLES.IssuedUnit.RemoteStorageIndicator + ",";
			insertIssuedUnit += TABLES.IssuedUnit.LastUpdateDate + ",";
			insertIssuedUnit += TABLES.IssuedUnit.LastUpdateUser + ",";
			insertIssuedUnit += TABLES.IssuedUnit.LastUpdateFunctionId + ")";
			insertIssuedUnit += "VALUES (";
			insertIssuedUnit += "'" + issuedUnitGuid.ToString() + "',";
			insertIssuedUnit += "'" + bloodUnitGuid.ToString() + "',";
			insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertIssuedUnit += "'" + Environment.UserName + "',";
			insertIssuedUnit += "'" + Environment.UserName + "',";
			insertIssuedUnit += "'10W P-KC',";
			insertIssuedUnit += "0,";
			insertIssuedUnit += "1,";
			insertIssuedUnit += "0,";
			insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertIssuedUnit += "'" + Environment.UserName + "',";
			insertIssuedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			//			string updateBloodUnitStatus = "UPDATE BloodUnitStatus SET ";
			//			updateBloodUnitStatus += TABLES.BloodUnitStatus.UnitStatusCode + " = '" + Common.Utility.GetUnitStatusCodeCharFromEnum(Common.UnitStatusCode.Issued).ToString() + "' ";
			//			updateBloodUnitStatus += "WHERE " + TABLES.BloodUnit.BloodUnitGuid + " = '" + bloodUnitGuid.ToString() + "'";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedComponent);
			UnitTestUtil.RunSQL(insertOrderedUnit);
			UnitTestUtil.RunSQL(insertBloodUnitTest1);
			UnitTestUtil.RunSQL(insertBloodUnitTest2);
			UnitTestUtil.RunSQL(insertIssuedUnit);
			//			UnitTestUtil.RunSQL(updateBloodUnitStatus);
			//
			//Create new Anti-D reagent to test against.
			DataTable dtReagents = Reagent.InitializeReagentsAndManufacturersTable();
			DataRow drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = Guid.NewGuid();
			drReagent[TABLES.ReagentType.ReagentTypeId] = 52; //Anti-D
			drReagent["ReagentName"] = "Test D Reagent";
			drReagent["ReceiptDate"] = DateTime.Now;
			drReagent["ReceiptTechId"] = UnitTestConfig.User_Technologist;
			drReagent["InvoiceNumber"] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "D"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent["NumberVialsReceived"] = 20;
			drReagent["NumberVialsAvailable"] = 15;
			drReagent["Comments"] = "Unit Test 1708";
			drReagent["InspectionIndicator"] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent["ReagentTypeName"] = "Anti-D";
			drReagent[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drReagent["RecordStatusCode"] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Create new Anti-Dc reagent to for Pos control.
			Guid antiDcGuid = Guid.NewGuid();
			drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = antiDcGuid;
			drReagent[TABLES.ReagentType.ReagentTypeId] = 53; //Screening Cells
			drReagent["ReagentName"] = "Test Dc Reagent";
			drReagent["ReceiptDate"] = DateTime.Now;
			drReagent["ReceiptTechId"] = UnitTestConfig.User_Technologist;
			drReagent["InvoiceNumber"] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "Dc"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent["NumberVialsReceived"] = 20;
			drReagent["NumberVialsAvailable"] = 15;
			drReagent["Comments"] = "Unit Test 1708";
			drReagent["InspectionIndicator"] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent["ReagentTypeName"] = "Anti-D Control";
			drReagent[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drReagent["RecordStatusCode"] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Insert new reagents
			BOL.Reagent.InsertNewReagent(dtReagents, BOL.ReagentType.GetReagentTypes(), Common.UpdateFunction.UnitTests);
			//
			Guid buGuid = bloodUnitGuid;
			Guid[] buGuids = new Guid[] {buGuid};
			Guid rackGuid = (Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			//
			//Now we will insert a new antisera worklist
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(Guid.NewGuid());
			tmpAW.TestingMethodCode = Common.TestingMethod.Gel;
			tmpAW.WorklistCreateDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			tmpAW.WorklistName = Environment.UserName;
			//
			DataTable tmpAWT = new DataTable();
			tmpAWT.Columns.Add("AntiseraWorklistTypingGuid", typeof(Guid));
			tmpAWT.Columns.Add(TABLES.AntiseraWorklist.AntiseraWorklistGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.ReagentGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.RackGuid,typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.ReactivityPhaseCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.Comments,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.DivisionCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.TestWithId,typeof(int));
			tmpAWT.Columns.Add("RackQCOverrideComment",typeof(string));
			tmpAWT.Columns.Add("ExpiredOverrideComment",typeof(string));
			tmpAWT.Columns.Add("PhaseOverrideComment",typeof(string));
			//
			DataRow drAWT = tmpAWT.NewRow();
			drAWT[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid] = Guid.NewGuid();
			drAWT[TABLES.AntiseraWorklist.AntiseraWorklistGuid] = tmpAW.AntiseraWorklistGuid;
			drAWT[TABLES.OrderableTest.OrderableTestId] = Convert.ToInt32(Common.OrderableTest.AGwD).ToString();
			drAWT[TABLES.RackLot.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drAWT[TABLES.RackLot.RackGuid] = rackGuid;
			drAWT[TABLES.RackLot.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.ThreeSevenandAHG).ToString();
			drAWT[TABLES.RackLot.Comments] = "";
			drAWT[TABLES.RackLot.DivisionCode] = this.TestDivisionCode;
			drAWT["RackQCOverrideComment"] = "Unit Test 1708";
			drAWT["ExpiredOverrideComment"] = "Unit Test 1708";
			drAWT["PhaseOverrideComment"] = "Unit Test 1708";
			tmpAWT.Rows.Add(drAWT);
			//
			//Save the antisera worklist
			tmpAW.Save(tmpAWT,dtUnit,Environment.UserName,Common.UpdateFunction.UnitTests,new Guid[] {buGuid}, antiDcGuid,"", false);
			//
			//Now we need to load the saved antisera worklist, complete the tests and save again.
			BOL.AntiseraWorklist aw = new BOL.AntiseraWorklist(tmpAW.AntiseraWorklistGuid);
			DataTable dtAWT = BOL.AntiseraWorklist.GetAntiseraWorklistDetails(tmpAW.AntiseraWorklistGuid);
			DataTable dtUnits = BOL.AntiseraWorklist.GetAntiseraWorklistUnits(tmpAW.AntiseraWorklistGuid);
			//
			DataRow drRackLot = dtAWT.Rows[0];
			DataRow drUnit = dtUnits.Rows[0];
			DataRow drDReagent = dtReagents.Rows[0];
			DataRow drDcReagent = dtReagents.Rows[1];
			//
			//Now create WeakD grid table
			DataTable dtWD = new DataTable("WeakD");
			//
			dtWD.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtWD.Columns.Add(TABLES.ExceptionUnitIssue.UnitId, typeof(string));
			dtWD.Columns.Add(TABLES.BloodProduct.ProductName, typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.D37,typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.Dc37,typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.DAHG,typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.DcAHG,typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.DCC, typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.DcCC, typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.Interp, typeof(string));			
			dtWD.Columns.Add(ARTIFICIAL.Comment, typeof(string));
			dtWD.Columns.Add(TABLES.ValidRhResult.SystemInterp, typeof(string));
			dtWD.Columns.Add(TABLES.BloodUnit.BloodUnitGuid, typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.AntiDReagentGuid, typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.DControlReagentGuid, typeof(Guid));
			dtWD.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(string));
			dtWD.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.D37Guid,typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.Dc37Guid,typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.DAHGGuid,typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.DcAHGGuid,typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.DCCGuid, typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.DcCCGuid, typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.InterpGuid, typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.D37RowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.Dc37RowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.DAHGRowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.DcAHGRowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.DCCRowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.DcCCRowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.InterpRowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.D37Save, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.Dc37Save, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.DAHGSave, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.DcAHGSave, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.DCCSave, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.DcCCSave, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.InterpSave, typeof(bool));
			dtWD.Columns.Add(TABLES.BloodUnitStatus.QuarantineIndicator, typeof(bool));
			dtWD.Columns.Add(TABLES.VamcDivision.DivisionCode, typeof(string));
			dtWD.Columns.Add(TABLES.Rack.RackGuid, typeof(Guid));
			dtWD.Columns.Add(TABLES.ExceptionQc.ExceptionComment, typeof(string));
			//
			DataRow dr = dtWD.NewRow();
			dr[ARTIFICIAL.Indicator] = "";
			dr[TABLES.ExceptionUnitIssue.UnitId] = drUnit[TABLES.BloodUnit.EyeReadableUnitId];
			dr[TABLES.BloodProduct.ProductName] = drUnit[TABLES.BloodProduct.ProductShortName];
			dr[ARTIFICIAL.D37] = "4";
			dr[ARTIFICIAL.Dc37] = "0";
			dr[ARTIFICIAL.DAHG] = "4";
			dr[ARTIFICIAL.DcAHG] = "0";
			dr[ARTIFICIAL.DCC] = "4";
			dr[ARTIFICIAL.DcCC] = "4";
			dr[ARTIFICIAL.Interp] = "I";
			dr[ARTIFICIAL.Comment] = "Unit Testing";
			dr[TABLES.ValidRhResult.SystemInterp] = "I";
			dr[TABLES.BloodUnit.BloodUnitGuid] = drUnit[TABLES.BloodUnit.BloodUnitGuid];
			dr[ARTIFICIAL.AntiDReagentGuid] = drDReagent[TABLES.Reagent.ReagentGuid];
			dr[ARTIFICIAL.DControlReagentGuid] = drDcReagent[TABLES.Reagent.ReagentGuid];
			dr[TABLES.ReactivityPhase.ReactivityPhaseCode] = drRackLot[TABLES.ReactivityPhase.ReactivityPhaseCode];
			dr[TABLES.OrderableTest.OrderableTestId] = drRackLot[TABLES.OrderableTest.OrderableTestId];
			dr[ARTIFICIAL.IndicatorMessage] = "";
			dr[ARTIFICIAL.PartiallyCompleted] = false;
			dr[ARTIFICIAL.D37Guid] = Guid.Empty;
			dr[ARTIFICIAL.Dc37Guid] = Guid.Empty;
			dr[ARTIFICIAL.DAHGGuid] = Guid.Empty;
			dr[ARTIFICIAL.DcAHGGuid] = Guid.Empty;
			dr[ARTIFICIAL.DCCGuid] = Guid.Empty;
			dr[ARTIFICIAL.DcCCGuid] = Guid.Empty;
			dr[ARTIFICIAL.InterpGuid] = Guid.Empty;
			dr[ARTIFICIAL.D37RowVersion] = DBNull.Value;
			dr[ARTIFICIAL.Dc37RowVersion] = DBNull.Value;
			dr[ARTIFICIAL.DAHGRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.DcAHGRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.DCCRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.DcCCRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.D37Save] = true;
			dr[ARTIFICIAL.Dc37Save] = true;
			dr[ARTIFICIAL.DAHGSave] = true;
			dr[ARTIFICIAL.DcAHGSave] = true;
			dr[ARTIFICIAL.DCCSave] = true;
			dr[ARTIFICIAL.DcCCSave] = true;
			dr[ARTIFICIAL.InterpSave] = true;
			dr[TABLES.BloodUnitStatus.QuarantineIndicator] = true;
			dr[TABLES.VamcDivision.DivisionCode] = drRackLot[TABLES.RackLot.DivisionCode].ToString();
			dr[TABLES.Rack.RackGuid] = drRackLot[TABLES.RackLot.RackGuid];
			dr[TABLES.ExceptionQc.ExceptionComment] = "Unit Test 1708";
			//
			DataTable results = BOL.AntiseraWorklist.GetTestResultsForAntiseraWorklist((Guid)drUnit[TABLES.BloodUnit.BloodUnitGuid],(Guid)drRackLot["AntiseraWorklistTypingGuid"]);
			//
			DataTable testTypes = BOL.BloodTestType.GetBloodTestTypes(drRackLot[TABLES.OrderableTest.OrderableTestId].ToString());
			//
			foreach(DataRow result in results.Rows)
			{
				DataRow[] relevantTest = testTypes.Select(TABLES.BloodTestType.BloodTestTypeId+" = '" + result[TABLES.BloodTestType.BloodTestTypeId].ToString() + "'");
				if (relevantTest.Length >0)
				{
					string bloodTestType = relevantTest[0][TABLES.BloodTestType.BloodTestName].ToString();
					if (bloodTestType.IndexOf("wD 37") > -1)
					{
						dr[ARTIFICIAL.D37Guid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.D37RowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf("D Control 37") > -1)
					{
						dr[ARTIFICIAL.Dc37Guid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.Dc37RowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf("wD AHG") > -1)
					{
						dr[ARTIFICIAL.DAHGGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.DAHGRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf("D Control AHG") > -1)
					{
						dr[ARTIFICIAL.DcAHGGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.DcAHGRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf("wD CC") > -1)
					{
						dr[ARTIFICIAL.DCCGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.DCCRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf("D Control CC") > -1)
					{
						dr[ARTIFICIAL.DcCCGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.DcCCRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf(ARTIFICIAL.Interp) > -1)
					{
						dr[ARTIFICIAL.InterpGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.InterpRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
				}
			}
			//
			dtWD.Rows.Add(dr);
			//
			//Finally, after setting up all that data, we can test the method!!!!!!!!! Nice!
			//
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.AntigenPhenotypingMultipleTestPhasesQC);
			ArrayList workloadProcessIds = new ArrayList(1);
			workloadProcessIds.Add(Common.WorkloadProcessID.AntigenPhenotypingMultipleTestPhasesQC);
			workloadProcessIds.Add(Common.WorkloadProcessID.Unknown);
			bool retValue = BOL.BloodUnitTest.SaveWeakDBloodUnitTests((Guid)drRackLot[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid],tmpAW,dtWD, Common.UpdateFunction.UC041FrmRecordPhenotypeResults, workloadProcessIds, buGuids);  
			//
			Assert.IsTrue(retValue);
		}

		[Test]
		public void SaveWeakDBloodUnitTests3_Pass()
		{
			//
			//For 100% coverage, we must issue a unit first!
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}
			//
			Guid bloodUnitGuid = Guid.NewGuid();
			//
			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			Guid bloodProductGuid = (Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);
			DataTable dtUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE BloodunitGuid = '"+ bloodUnitGuid.ToString()+"'");
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedComponentGuid = Guid.NewGuid();
			string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
			insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
			insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
			insertOrderedComponent += "VALUES (";
			insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedComponent += "'1',";
            insertOrderedComponent += "'" + SprocHelper.GetNewCprsOrderNumber() + "',";
			insertOrderedComponent += "'2',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'I',";
			insertOrderedComponent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'" + Environment.UserName + "',";
			insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedUnitGuid = Guid.NewGuid();
			string insertOrderedUnit = "INSERT INTO ORDEREDUNIT (";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedComponentGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.BloodUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchRequiredIndicator + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchResultCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchTechId + ",";
			insertOrderedUnit += TABLES.OrderedUnit.RecordStatusCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.DivisionCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateUser + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateFunctionId + ")";
			insertOrderedUnit += "VALUES (";
			insertOrderedUnit += "'" + orderedUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedUnit += "'" + bloodUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "1,";
			insertOrderedUnit += "'C',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'A',";
			insertOrderedUnit += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			string insertBloodUnitTest1 = "INSERT INTO BLOODUNITTEST (";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.BloodUnitTestGuid + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.BloodUnitGuid + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.BloodTestTypeId + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.TestDate + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.TestTechId + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.TestResultId + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.EntryTechId + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.EntryMethodCode + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.OrderedComponentGuid + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.OrderedUnitGuid + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.ReactivityPhaseCode + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.RecordStatusCode + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.DivisionCode + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.LastUpdateDate + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.LastUpdateUser + ",";
			insertBloodUnitTest1 += TABLES.BloodUnitTest.LastUpdateFunctionId + ")";
			insertBloodUnitTest1 += "VALUES (";
			insertBloodUnitTest1 += "'" + bloodUnitTestGuid1.ToString() + "',";
			insertBloodUnitTest1 += "'" + bloodUnitGuid.ToString() + "',";
			insertBloodUnitTest1 += "'100',";
			insertBloodUnitTest1 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest1 += "'" + Environment.UserName + "',";
			insertBloodUnitTest1 += "'0',";
			insertBloodUnitTest1 += "'" + Environment.UserName + "',";
			insertBloodUnitTest1 += "'M',";
			insertBloodUnitTest1 += "'" + orderedComponentGuid.ToString() + "',";
			insertBloodUnitTest1 += "'" + orderedUnitGuid.ToString() + "',";
			insertBloodUnitTest1 += "'2',";
			insertBloodUnitTest1 += "'A',";
			insertBloodUnitTest1 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertBloodUnitTest1 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest1 += "'" + Environment.UserName + "',";
			insertBloodUnitTest1 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			string insertBloodUnitTest2 = "INSERT INTO BLOODUNITTEST (";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.BloodUnitTestGuid + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.BloodUnitGuid + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.BloodTestTypeId + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.TestDate + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.TestTechId + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.TestResultId + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.EntryTechId + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.EntryMethodCode + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.OrderedComponentGuid + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.OrderedUnitGuid + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.ReactivityPhaseCode + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.RecordStatusCode + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.DivisionCode + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.LastUpdateDate + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.LastUpdateUser + ",";
			insertBloodUnitTest2 += TABLES.BloodUnitTest.LastUpdateFunctionId + ")";
			insertBloodUnitTest2 += "VALUES (";
			insertBloodUnitTest2 += "'" + bloodUnitTestGuid2.ToString() + "',";
			insertBloodUnitTest2 += "'" + bloodUnitGuid.ToString() + "',";
			insertBloodUnitTest2 += "'102',";
			insertBloodUnitTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest2 += "'" + Environment.UserName + "',";
			insertBloodUnitTest2 += "'C',";
			insertBloodUnitTest2 += "'" + Environment.UserName + "',";
			insertBloodUnitTest2 += "'M',";
			insertBloodUnitTest2 += "'" + orderedComponentGuid.ToString() + "',";
			insertBloodUnitTest2 += "'" + orderedUnitGuid.ToString() + "',";
			insertBloodUnitTest2 += "'2',";
			insertBloodUnitTest2 += "'A',";
			insertBloodUnitTest2 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertBloodUnitTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest2 += "'" + Environment.UserName + "',";
			insertBloodUnitTest2 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid issuedUnitGuid = Guid.NewGuid();
			string insertIssuedUnit = "INSERT INTO ISSUEDUNIT (";
			insertIssuedUnit += TABLES.IssuedUnit.IssuedUnitGuid + ",";
			insertIssuedUnit += TABLES.IssuedUnit.BloodUnitGuid + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueDateTime + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueTechId + ",";
			insertIssuedUnit += TABLES.IssuedUnit.TransporterName + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueToLocationName + ",";
			insertIssuedUnit += TABLES.IssuedUnit.InPatientLocationIndicator + ",";
			insertIssuedUnit += TABLES.IssuedUnit.IssueSatisfactoryIndicator + ",";
			insertIssuedUnit += TABLES.IssuedUnit.RemoteStorageIndicator + ",";
			insertIssuedUnit += TABLES.IssuedUnit.LastUpdateDate + ",";
			insertIssuedUnit += TABLES.IssuedUnit.LastUpdateUser + ",";
			insertIssuedUnit += TABLES.IssuedUnit.LastUpdateFunctionId + ")";
			insertIssuedUnit += "VALUES (";
			insertIssuedUnit += "'" + issuedUnitGuid.ToString() + "',";
			insertIssuedUnit += "'" + bloodUnitGuid.ToString() + "',";
			insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertIssuedUnit += "'" + Environment.UserName + "',";
			insertIssuedUnit += "'" + Environment.UserName + "',";
			insertIssuedUnit += "'10W P-KC',";
			insertIssuedUnit += "0,";
			insertIssuedUnit += "1,";
			insertIssuedUnit += "0,";
			insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertIssuedUnit += "'" + Environment.UserName + "',";
			insertIssuedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			//			string updateBloodUnitStatus = "UPDATE BloodUnitStatus SET ";
			//			updateBloodUnitStatus += TABLES.BloodUnitStatus.UnitStatusCode + " = '" + Common.Utility.GetUnitStatusCodeCharFromEnum(Common.UnitStatusCode.Issued).ToString() + "' ";
			//			updateBloodUnitStatus += "WHERE " + TABLES.BloodUnit.BloodUnitGuid + " = '" + bloodUnitGuid.ToString() + "'";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedComponent);
			UnitTestUtil.RunSQL(insertOrderedUnit);
			UnitTestUtil.RunSQL(insertBloodUnitTest1);
			UnitTestUtil.RunSQL(insertBloodUnitTest2);
			UnitTestUtil.RunSQL(insertIssuedUnit);
			//			UnitTestUtil.RunSQL(updateBloodUnitStatus);
			//
			//Create new Anti-D reagent to test against.
			DataTable dtReagents = Reagent.InitializeReagentsAndManufacturersTable();
			DataRow drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = Guid.NewGuid();
			drReagent[TABLES.ReagentType.ReagentTypeId] = 52; //Anti-D
			drReagent["ReagentName"] = "Test D Reagent";
			drReagent["ReceiptDate"] = DateTime.Now;
			drReagent["ReceiptTechId"] = UnitTestConfig.User_Technologist;
			drReagent["InvoiceNumber"] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "D"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent["NumberVialsReceived"] = 20;
			drReagent["NumberVialsAvailable"] = 15;
			drReagent["Comments"] = "Unit Test 1708";
			drReagent["InspectionIndicator"] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent["ReagentTypeName"] = "Anti-D";
			drReagent[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drReagent["RecordStatusCode"] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Create new Anti-Dc reagent to for Pos control.
			Guid antiDcGuid = Guid.NewGuid();
			drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = antiDcGuid;
			drReagent[TABLES.ReagentType.ReagentTypeId] = 53; //Screening Cells
			drReagent["ReagentName"] = "Test Dc Reagent";
			drReagent["ReceiptDate"] = DateTime.Now;
			drReagent["ReceiptTechId"] = UnitTestConfig.User_Technologist;
			drReagent["InvoiceNumber"] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "Dc"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent["NumberVialsReceived"] = 20;
			drReagent["NumberVialsAvailable"] = 15;
			drReagent["Comments"] = "Unit Test 1708";
			drReagent["InspectionIndicator"] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent["ReagentTypeName"] = "Anti-D Control";
			drReagent[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drReagent["RecordStatusCode"] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Insert new reagents
			BOL.Reagent.InsertNewReagent(dtReagents, BOL.ReagentType.GetReagentTypes(), Common.UpdateFunction.UnitTests);
			//
			Guid buGuid = bloodUnitGuid;
			Guid[] buGuids = new Guid[] {buGuid};
			Guid rackGuid = (Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			//
			//Now we will insert a new antisera worklist
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(Guid.NewGuid());
			tmpAW.TestingMethodCode = Common.TestingMethod.Gel;
			tmpAW.WorklistCreateDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			tmpAW.WorklistName = Environment.UserName;
			//
			DataTable tmpAWT = new DataTable();
			tmpAWT.Columns.Add("AntiseraWorklistTypingGuid", typeof(Guid));
			tmpAWT.Columns.Add(TABLES.AntiseraWorklist.AntiseraWorklistGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.ReagentGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.RackGuid,typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.ReactivityPhaseCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.Comments,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.DivisionCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.TestWithId,typeof(int));
			tmpAWT.Columns.Add("RackQCOverrideComment",typeof(string));
			tmpAWT.Columns.Add("ExpiredOverrideComment",typeof(string));
			tmpAWT.Columns.Add("PhaseOverrideComment",typeof(string));
			//
			DataRow drAWT = tmpAWT.NewRow();
			drAWT[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid] = Guid.NewGuid();
			drAWT[TABLES.AntiseraWorklist.AntiseraWorklistGuid] = tmpAW.AntiseraWorklistGuid;
			drAWT[TABLES.OrderableTest.OrderableTestId] = Convert.ToInt32(Common.OrderableTest.AGwD).ToString();
			drAWT[TABLES.RackLot.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drAWT[TABLES.RackLot.RackGuid] = rackGuid;
			drAWT[TABLES.RackLot.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.ThreeSevenandAHG).ToString();
			drAWT[TABLES.RackLot.Comments] = "";
			drAWT[TABLES.RackLot.DivisionCode] = this.TestDivisionCode;
			drAWT["RackQCOverrideComment"] = "Unit Test 1708";
			drAWT["ExpiredOverrideComment"] = "Unit Test 1708";
			drAWT["PhaseOverrideComment"] = "Unit Test 1708";
			tmpAWT.Rows.Add(drAWT);
			//
			//Save the antisera worklist
			tmpAW.Save(tmpAWT,dtUnit,Environment.UserName,Common.UpdateFunction.UnitTests,new Guid[] {buGuid}, antiDcGuid,"", false);
			//
			//Now we need to load the saved antisera worklist, complete the tests and save again.
			BOL.AntiseraWorklist aw = new BOL.AntiseraWorklist(tmpAW.AntiseraWorklistGuid);
			DataTable dtAWT = BOL.AntiseraWorklist.GetAntiseraWorklistDetails(tmpAW.AntiseraWorklistGuid);
			DataTable dtUnits = BOL.AntiseraWorklist.GetAntiseraWorklistUnits(tmpAW.AntiseraWorklistGuid);
			//
			DataRow drRackLot = dtAWT.Rows[0];
			DataRow drUnit = dtUnits.Rows[0];
			DataRow drDReagent = dtReagents.Rows[0];
			DataRow drDcReagent = dtReagents.Rows[1];
			//
			//Now create WeakD grid table
			DataTable dtWD = new DataTable("WeakD");
			//
			dtWD.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtWD.Columns.Add(TABLES.ExceptionUnitIssue.UnitId, typeof(string));
			dtWD.Columns.Add(TABLES.BloodProduct.ProductName, typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.D37,typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.Dc37,typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.DAHG,typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.DcAHG,typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.DCC, typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.DcCC, typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.Interp, typeof(string));			
			dtWD.Columns.Add(ARTIFICIAL.Comment, typeof(string));
			dtWD.Columns.Add(TABLES.ValidRhResult.SystemInterp, typeof(string));
			dtWD.Columns.Add(TABLES.BloodUnit.BloodUnitGuid, typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.AntiDReagentGuid, typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.DControlReagentGuid, typeof(Guid));
			dtWD.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(string));
			dtWD.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.D37Guid,typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.Dc37Guid,typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.DAHGGuid,typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.DcAHGGuid,typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.DCCGuid, typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.DcCCGuid, typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.InterpGuid, typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.D37RowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.Dc37RowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.DAHGRowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.DcAHGRowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.DCCRowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.DcCCRowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.InterpRowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.D37Save, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.Dc37Save, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.DAHGSave, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.DcAHGSave, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.DCCSave, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.DcCCSave, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.InterpSave, typeof(bool));
			dtWD.Columns.Add(TABLES.BloodUnitStatus.QuarantineIndicator, typeof(bool));
			dtWD.Columns.Add(TABLES.VamcDivision.DivisionCode, typeof(string));
			dtWD.Columns.Add(TABLES.Rack.RackGuid, typeof(Guid));
			dtWD.Columns.Add(TABLES.ExceptionQc.ExceptionComment, typeof(string));
			//
			DataRow dr = dtWD.NewRow();
			dr[ARTIFICIAL.Indicator] = "";
			dr[TABLES.ExceptionUnitIssue.UnitId] = drUnit[TABLES.BloodUnit.EyeReadableUnitId];
			dr[TABLES.BloodProduct.ProductName] = drUnit[TABLES.BloodProduct.ProductShortName];
			dr[ARTIFICIAL.D37] = "4";
			dr[ARTIFICIAL.Dc37] = "0";
			dr[ARTIFICIAL.DAHG] = "4";
			dr[ARTIFICIAL.DcAHG] = "0";
			dr[ARTIFICIAL.DCC] = "4";
			dr[ARTIFICIAL.DcCC] = "4";
			dr[ARTIFICIAL.Interp] = "";
			dr[ARTIFICIAL.Comment] = "Unit Testing";
			dr[TABLES.ValidRhResult.SystemInterp] = "I";
			dr[TABLES.BloodUnit.BloodUnitGuid] = drUnit[TABLES.BloodUnit.BloodUnitGuid];
			dr[ARTIFICIAL.AntiDReagentGuid] = drDReagent[TABLES.Reagent.ReagentGuid];
			dr[ARTIFICIAL.DControlReagentGuid] = drDcReagent[TABLES.Reagent.ReagentGuid];
			dr[TABLES.ReactivityPhase.ReactivityPhaseCode] = drRackLot[TABLES.ReactivityPhase.ReactivityPhaseCode];
			dr[TABLES.OrderableTest.OrderableTestId] = drRackLot[TABLES.OrderableTest.OrderableTestId];
			dr[ARTIFICIAL.IndicatorMessage] = "";
			dr[ARTIFICIAL.PartiallyCompleted] = false;
			dr[ARTIFICIAL.D37Guid] = Guid.Empty;
			dr[ARTIFICIAL.Dc37Guid] = Guid.Empty;
			dr[ARTIFICIAL.DAHGGuid] = Guid.Empty;
			dr[ARTIFICIAL.DcAHGGuid] = Guid.Empty;
			dr[ARTIFICIAL.DCCGuid] = Guid.Empty;
			dr[ARTIFICIAL.DcCCGuid] = Guid.Empty;
			dr[ARTIFICIAL.InterpGuid] = Guid.Empty;
			dr[ARTIFICIAL.D37RowVersion] = DBNull.Value;
			dr[ARTIFICIAL.Dc37RowVersion] = DBNull.Value;
			dr[ARTIFICIAL.DAHGRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.DcAHGRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.DCCRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.DcCCRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.D37Save] = true;
			dr[ARTIFICIAL.Dc37Save] = true;
			dr[ARTIFICIAL.DAHGSave] = true;
			dr[ARTIFICIAL.DcAHGSave] = true;
			dr[ARTIFICIAL.DCCSave] = true;
			dr[ARTIFICIAL.DcCCSave] = true;
			dr[ARTIFICIAL.InterpSave] = true;
			dr[TABLES.BloodUnitStatus.QuarantineIndicator] = true;
			dr[TABLES.VamcDivision.DivisionCode] = drRackLot[TABLES.RackLot.DivisionCode].ToString();
			dr[TABLES.Rack.RackGuid] = drRackLot[TABLES.RackLot.RackGuid];
			dr[TABLES.ExceptionQc.ExceptionComment] = "Unit Test 1708";
			//
			DataTable results = BOL.AntiseraWorklist.GetTestResultsForAntiseraWorklist((Guid)drUnit[TABLES.BloodUnit.BloodUnitGuid],(Guid)drRackLot["AntiseraWorklistTypingGuid"]);
			//
			DataTable testTypes = BOL.BloodTestType.GetBloodTestTypes(drRackLot[TABLES.OrderableTest.OrderableTestId].ToString());
			//
			foreach(DataRow result in results.Rows)
			{
				DataRow[] relevantTest = testTypes.Select(TABLES.BloodTestType.BloodTestTypeId+" = '" + result[TABLES.BloodTestType.BloodTestTypeId].ToString() + "'");
				if (relevantTest.Length >0)
				{
					string bloodTestType = relevantTest[0][TABLES.BloodTestType.BloodTestName].ToString();
					if (bloodTestType.IndexOf("wD 37") > -1)
					{
						dr[ARTIFICIAL.D37Guid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.D37RowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf("D Control 37") > -1)
					{
						dr[ARTIFICIAL.Dc37Guid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.Dc37RowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf("wD AHG") > -1)
					{
						dr[ARTIFICIAL.DAHGGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.DAHGRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf("D Control AHG") > -1)
					{
						dr[ARTIFICIAL.DcAHGGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.DcAHGRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf("wD CC") > -1)
					{
						dr[ARTIFICIAL.DCCGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.DCCRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf("D Control CC") > -1)
					{
						dr[ARTIFICIAL.DcCCGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.DcCCRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf(ARTIFICIAL.Interp) > -1)
					{
						dr[ARTIFICIAL.InterpGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.InterpRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
				}
			}
			//
			dtWD.Rows.Add(dr);
			//
			//Finally, after setting up all that data, we can test the method!!!!!!!!! Nice!
			//
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.AntigenPhenotypingMultipleTestPhasesQC);
			ArrayList workloadProcessIds = new ArrayList(1);
			workloadProcessIds.Add(Common.WorkloadProcessID.AntigenPhenotypingMultipleTestPhasesQC);
			workloadProcessIds.Add(Common.WorkloadProcessID.Unknown);
			bool retValue = BOL.BloodUnitTest.SaveWeakDBloodUnitTests((Guid)drRackLot[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid],tmpAW,dtWD, Common.UpdateFunction.UC041FrmRecordPhenotypeResults, workloadProcessIds, buGuids);  
			//
			Assert.IsTrue(retValue);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void SaveWeakDBloodUnitTests_Fail()
		{
			Guid buGuid = (Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			Guid awGuid = (Guid)this._dtAntiseraWorklistTyping.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistGuid];			
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(awGuid);
			DataTable dtSave = new DataTable();
			dtSave.Rows.Add(dtSave.NewRow());
			Guid [] buGuids = {buGuid};

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.AntigenPhenotypingMultipleTestPhasesQC);
			ArrayList workloadProcessIds = new ArrayList(1);
			workloadProcessIds.Add(Common.WorkloadProcessID.AntigenPhenotypingMultipleTestPhasesQC);
			workloadProcessIds.Add(Common.WorkloadProcessID.Unknown);
			bool retValue = BOL.BloodUnitTest.SaveWeakDBloodUnitTests(Guid.NewGuid(), tmpAW, dtSave, Common.UpdateFunction.UnitTests, workloadProcessIds, buGuids);
			
			Assert.IsTrue(retValue);
		}

		[Test]
		public void BuildBloodUnitTestRowsFromXM_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}
			//
			Guid bloodUnitGuid = Guid.NewGuid();
			//
			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			Guid bloodProductGuid = (Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
//NOTE-- This unit was being created in "C" status, until BLOODUNITSTATUS Changes
			DataCreator.CreateBloodUnit(bloodUnitGuid, Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);
			DataTable dtUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE BloodunitGuid = '"+ bloodUnitGuid.ToString()+"'");
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedComponentGuid = Guid.NewGuid();
			string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
			insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
			insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
			insertOrderedComponent += "VALUES (";
			insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedComponent += "'1',";
            insertOrderedComponent += "'" + SprocHelper.GetNewCprsOrderNumber() + "',";
			insertOrderedComponent += "'2',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'I',";
			insertOrderedComponent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'" + Environment.UserName + "',";
			insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuid = Guid.NewGuid();
			string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
			insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.RelatedComponentGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTest += "VALUES (";
			insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
			insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTest += "'4',";
			insertOrderedTest += "'A',";
			insertOrderedTest += "'P',";
			insertOrderedTest += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTest += "'UnitTestUser',";
			insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedUnitGuid = Guid.NewGuid();
			string insertOrderedUnit = "INSERT INTO ORDEREDUNIT (";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedComponentGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.BloodUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchRequiredIndicator + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchResultCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchTechId + ",";
			insertOrderedUnit += TABLES.OrderedUnit.RecordStatusCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.DivisionCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateUser + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateFunctionId + ")";
			insertOrderedUnit += "VALUES (";
			insertOrderedUnit += "'" + orderedUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedUnit += "'" + bloodUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "1,";
			insertOrderedUnit += "'Z',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'A',";
			insertOrderedUnit += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedComponent);
			UnitTestUtil.RunSQL(insertOrderedTest);
			UnitTestUtil.RunSQL(insertOrderedUnit);

			DataTable dtBUTInsert = this._dtBloodUnitTest.Clone();
			DataTable dtBUTUpdate = this._dtBloodUnitTest.Clone();
			DataTable dtOrderedUnit = this._dtOrderedUnit.Clone();

			dtBUTInsert.Rows.Clear();
			dtBUTUpdate.Rows.Clear();

			DataTable dtXMResults = new DataTable();

			dtXMResults.Columns.Add(TABLES.OrderableTest.OrderableTestId, typeof(int));
			dtXMResults.Columns.Add(ARTIFICIAL.IS, typeof(String));
			dtXMResults.Columns.Add(ARTIFICIAL.C37, typeof(String));
			dtXMResults.Columns.Add(ARTIFICIAL.AHG, typeof(String));
			dtXMResults.Columns.Add(ARTIFICIAL.CC, typeof(String));
			dtXMResults.Columns.Add(ARTIFICIAL.XMInterp, typeof(String));			
			dtXMResults.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.XMInterpSave, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.ISGuid, typeof(Guid));
			dtXMResults.Columns.Add(ARTIFICIAL.C37Guid, typeof(Guid));
			dtXMResults.Columns.Add(ARTIFICIAL.AHGGuid, typeof(Guid));
			dtXMResults.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtXMResults.Columns.Add(ARTIFICIAL.XMInterpGuid, typeof(Guid));
			dtXMResults.Columns.Add(ARTIFICIAL.ISRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.C37RowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.XMInterpRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.OrderedUnitRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(TABLES.OrderedUnit.OrderedUnitGuid, typeof(Guid));
			dtXMResults.Columns.Add(TABLES.OrderedTest.OrderedTestGuid, typeof(Guid));
			dtXMResults.Columns.Add(TABLES.BloodUnit.BloodUnitGuid, typeof(Guid));
			dtXMResults.Columns.Add(TABLES.OrderedComponent.OrderedComponentGuid, typeof(Guid));	
			dtXMResults.Columns.Add(TABLES.BloodUnitTest.CorrectedResultIndicator, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.UnitStatusRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.XMComment, typeof(String));

			//Build the XMData
			DataRow drXMR = dtXMResults.NewRow();
			drXMR[TABLES.OrderableTest.OrderableTestId] = 9;		//9 = Crossmatch!
			drXMR[ARTIFICIAL.IS] = "0";
			drXMR[ARTIFICIAL.C37] = "";
			drXMR[ARTIFICIAL.AHG] = "0";
			drXMR[ARTIFICIAL.CC] = "4";
			drXMR[ARTIFICIAL.XMInterp] = "C";			
			drXMR[ARTIFICIAL.ISSave] = false;
			drXMR[ARTIFICIAL.C37Save] = true;
			drXMR[ARTIFICIAL.AHGSave] = true;
			drXMR[ARTIFICIAL.CCSave] = true;
			drXMR[ARTIFICIAL.XMInterpSave] = true;
			drXMR[ARTIFICIAL.ISGuid] = Guid.NewGuid();
			drXMR[ARTIFICIAL.C37Guid] = Guid.NewGuid();
			drXMR[ARTIFICIAL.AHGGuid] = Guid.NewGuid();
			drXMR[ARTIFICIAL.CCGuid] = Guid.NewGuid();
			drXMR[ARTIFICIAL.XMInterpGuid] = DBNull.Value;
			drXMR[ARTIFICIAL.ISRowVersion] = new byte[8];
			drXMR[ARTIFICIAL.C37RowVersion] = new byte[8];
			drXMR[ARTIFICIAL.AHGRowVersion] = new byte[8];
			drXMR[ARTIFICIAL.CCRowVersion] = new byte[8];
			drXMR[ARTIFICIAL.XMInterpRowVersion] = DBNull.Value;
			drXMR[ARTIFICIAL.OrderedUnitRowVersion] = new byte[8];
			drXMR[TABLES.OrderedUnit.OrderedUnitGuid] = orderedUnitGuid;
			drXMR[TABLES.OrderedTest.OrderedTestGuid] = orderedTestGuid;
			drXMR[TABLES.BloodUnit.BloodUnitGuid] = bloodUnitGuid;
			drXMR[TABLES.OrderedComponent.OrderedComponentGuid] = orderedComponentGuid;	
			drXMR[TABLES.BloodUnitTest.CorrectedResultIndicator] = true;
			drXMR[ARTIFICIAL.UnitStatusRowVersion] = new byte[8];
			drXMR[ARTIFICIAL.XMComment] = "X";

			dtXMResults.Rows.Add(drXMR);

			drXMR = dtXMResults.NewRow();
			drXMR[TABLES.OrderableTest.OrderableTestId] = 9;		//9 = Crossmatch!
			drXMR[ARTIFICIAL.IS] = "";
			drXMR[ARTIFICIAL.C37] = "";
			drXMR[ARTIFICIAL.AHG] = "";
			drXMR[ARTIFICIAL.CC] = "";
			drXMR[ARTIFICIAL.XMInterp] = "";			
			drXMR[ARTIFICIAL.ISSave] = true;
			drXMR[ARTIFICIAL.C37Save] = true;
			drXMR[ARTIFICIAL.AHGSave] = true;
			drXMR[ARTIFICIAL.CCSave] = true;
			drXMR[ARTIFICIAL.XMInterpSave] = true;
			drXMR[ARTIFICIAL.ISGuid] = DBNull.Value;
			drXMR[ARTIFICIAL.C37Guid] = DBNull.Value;
			drXMR[ARTIFICIAL.AHGGuid] = DBNull.Value;
			drXMR[ARTIFICIAL.CCGuid] = DBNull.Value;
			drXMR[ARTIFICIAL.XMInterpGuid] = DBNull.Value;
			drXMR[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			drXMR[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			drXMR[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			drXMR[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			drXMR[ARTIFICIAL.XMInterpRowVersion] = DBNull.Value;
			drXMR[ARTIFICIAL.OrderedUnitRowVersion] = new byte[8];
			drXMR[TABLES.OrderedUnit.OrderedUnitGuid] = orderedUnitGuid;
			drXMR[TABLES.OrderedTest.OrderedTestGuid] = orderedTestGuid;
			drXMR[TABLES.BloodUnit.BloodUnitGuid] = bloodUnitGuid;
			drXMR[TABLES.OrderedComponent.OrderedComponentGuid] = orderedComponentGuid;	
			drXMR[TABLES.BloodUnitTest.CorrectedResultIndicator] = true;
			drXMR[ARTIFICIAL.UnitStatusRowVersion] = new byte[8];
			drXMR[ARTIFICIAL.XMComment] = "X";

			dtXMResults.Rows.Add(drXMR);

			drXMR = dtXMResults.NewRow();
			drXMR[TABLES.OrderableTest.OrderableTestId] = 9;		//9 = Crossmatch!
			drXMR[ARTIFICIAL.IS] = "2";
			drXMR[ARTIFICIAL.C37] = "2";
			drXMR[ARTIFICIAL.AHG] = "3";
			drXMR[ARTIFICIAL.CC] = "4";
			drXMR[ARTIFICIAL.XMInterp] = "I";			
			drXMR[ARTIFICIAL.ISSave] = false;
			drXMR[ARTIFICIAL.C37Save] = true;
			drXMR[ARTIFICIAL.AHGSave] = true;
			drXMR[ARTIFICIAL.CCSave] = true;
			drXMR[ARTIFICIAL.XMInterpSave] = true;
			drXMR[ARTIFICIAL.ISGuid] = Guid.NewGuid();
			drXMR[ARTIFICIAL.C37Guid] = Guid.NewGuid();
			drXMR[ARTIFICIAL.AHGGuid] = Guid.NewGuid();
			drXMR[ARTIFICIAL.CCGuid] = Guid.NewGuid();
			drXMR[ARTIFICIAL.XMInterpGuid] = DBNull.Value;
			drXMR[ARTIFICIAL.ISRowVersion] = new byte[8];
			drXMR[ARTIFICIAL.C37RowVersion] = new byte[8];
			drXMR[ARTIFICIAL.AHGRowVersion] = new byte[8];
			drXMR[ARTIFICIAL.CCRowVersion] = new byte[8];
			drXMR[ARTIFICIAL.XMInterpRowVersion] = DBNull.Value;
			drXMR[ARTIFICIAL.OrderedUnitRowVersion] = new byte[8];
			drXMR[TABLES.OrderedUnit.OrderedUnitGuid] = orderedUnitGuid;
			drXMR[TABLES.OrderedTest.OrderedTestGuid] = orderedTestGuid;
			drXMR[TABLES.BloodUnit.BloodUnitGuid] = bloodUnitGuid;
			drXMR[TABLES.OrderedComponent.OrderedComponentGuid] = orderedComponentGuid;	
			drXMR[TABLES.BloodUnitTest.CorrectedResultIndicator] = true;
			drXMR[ARTIFICIAL.UnitStatusRowVersion] = new byte[8];
			drXMR[ARTIFICIAL.XMComment] = "X";

			dtXMResults.Rows.Add(drXMR);

			DateTime testDate = DateTime.Now;
			Guid rackGuid = Guid.NewGuid();
			string aiName = DateTime.Now.ToString();

			BOL.BloodUnitTest.BuildBloodUnitTestRowsFromXM(dtXMResults, dtBUTInsert, dtBUTUpdate, dtOrderedUnit, testDate, Common.LogonUser.LogonUserDivisionCode, Common.ReactivityPhase.IAT, this.TestDivisionCode, rackGuid, aiName, Common.UpdateFunction.UnitTests);
			
			Assert.AreEqual(dtBUTUpdate.Rows[0][TABLES.BloodUnitTest.TestTechId].ToString(), Common.LogonUser.LogonUserDivisionCode, TABLES.BloodUnitTest.TestTechId);
			Assert.AreEqual((DateTime)dtBUTUpdate.Rows[0][TABLES.BloodUnitTest.TestDate], testDate, TABLES.BloodUnitTest.TestDate);
			Assert.IsTrue(dtBUTInsert.Rows.Count == 7);
			Assert.IsTrue(dtBUTUpdate.Rows.Count == 6);
		}

		[Test]
		[ExpectedException(typeof(IndexOutOfRangeException))]
		public void BuildBloodUnitTestRowsFromXM_Fail()
		{
			DataTable dtXMResults = new DataTable();
			DataTable dtBUTInsert = new DataTable();
			DataTable dtBUTUpdate = new DataTable();
			DataTable dtOrderedUnit = new DataTable();

			DateTime testDate = DateTime.Now;
			Guid rackGuid = Guid.NewGuid();
			string aiName = DateTime.Now.ToString();

			BOL.BloodUnitTest.BuildBloodUnitTestRowsFromXM(dtXMResults, dtBUTInsert, dtBUTUpdate, dtOrderedUnit, testDate, Common.LogonUser.LogonUserDivisionCode, Common.ReactivityPhase.IAT, this.TestDivisionCode, rackGuid, aiName, Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void BuildXMFromBloodUnitTest_XM_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			Guid bloodUnitGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			if (this._dtBloodUnit.Rows.Count > 0)
			{
				bloodUnitGuid = (Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			}
			else
			{
				Assert.AreEqual(bloodUnitGuid, Guid.NewGuid(), "Blood unit does not exist");
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'UnitTestUser',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'UnitTestUser',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedComponentGuid = Guid.NewGuid();
			string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
			insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
			insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
			insertOrderedComponent += "VALUES (";
			insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedComponent += "'1',";
            insertOrderedComponent += "'" + SprocHelper.GetNewCprsOrderNumber() + "',";
			insertOrderedComponent += "'2',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'N',";
			insertOrderedComponent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'UnitTestUser',";
			insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedUnitGuid = Guid.NewGuid();
			string insertOrderedUnit = "INSERT INTO ORDEREDUNIT (";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedComponentGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.BloodUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.RecordStatusCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.DivisionCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateUser + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateFunctionId + ")";
			insertOrderedUnit += "VALUES (";
			insertOrderedUnit += "'" + orderedUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedUnit += "'" + bloodUnitGuid.ToString() + "',";
			insertOrderedUnit += "'A',";
			insertOrderedUnit += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "'UnitTestUser',";
			insertOrderedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid bloodUnitTestGuid = Guid.NewGuid();
			string insertBloodUnitTest = "INSERT INTO BLOODUNITTEST (";
			insertBloodUnitTest += TABLES.BloodUnitTest.BloodUnitTestGuid + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.BloodUnitGuid + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.BloodTestTypeId + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.TestDate + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.TestTechId + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.TestResultId + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.EntryTechId + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.EntryMethodCode + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.OrderedComponentGuid + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.OrderedUnitGuid + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.ReactivityPhaseCode + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.RecordStatusCode + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.DivisionCode + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.LastUpdateDate + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.LastUpdateUser + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.LastUpdateFunctionId + ")";
			insertBloodUnitTest += "VALUES (";
			insertBloodUnitTest += "'" + bloodUnitTestGuid.ToString() + "',";
			insertBloodUnitTest += "'" + bloodUnitGuid.ToString() + "',";
			insertBloodUnitTest += "'100',";
			insertBloodUnitTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest += "'UnitTestUser',";
			insertBloodUnitTest += "'0',";
			insertBloodUnitTest += "'UnitTestUser',";
			insertBloodUnitTest += "'M',";
			insertBloodUnitTest += "'" + orderedComponentGuid.ToString() + "',";
			insertBloodUnitTest += "'" + orderedUnitGuid.ToString() + "',";
			insertBloodUnitTest += "'2',";
			insertBloodUnitTest += "'A',";
			insertBloodUnitTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertBloodUnitTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest += "'UnitTestUser',";
			insertBloodUnitTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedComponent);
			UnitTestUtil.RunSQL(insertOrderedUnit);
			UnitTestUtil.RunSQL(insertBloodUnitTest);

			DataTable dtXMResults = new DataTable();

			dtXMResults.Columns.Add(TABLES.OrderableTest.OrderableTestId, typeof(int));
			dtXMResults.Columns.Add(ARTIFICIAL.IS, typeof(String));
			dtXMResults.Columns.Add(ARTIFICIAL.C37, typeof(String));
			dtXMResults.Columns.Add(ARTIFICIAL.AHG, typeof(String));
			dtXMResults.Columns.Add(ARTIFICIAL.CC, typeof(String));
			dtXMResults.Columns.Add(ARTIFICIAL.XMInterp, typeof(String));			
			dtXMResults.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.XMInterpSave, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.ISGuid, typeof(Guid));
			dtXMResults.Columns.Add(ARTIFICIAL.C37Guid, typeof(Guid));
			dtXMResults.Columns.Add(ARTIFICIAL.AHGGuid, typeof(Guid));
			dtXMResults.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtXMResults.Columns.Add(ARTIFICIAL.XMInterpGuid, typeof(Guid));
			dtXMResults.Columns.Add(ARTIFICIAL.ISRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.C37RowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.XMInterpRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.OrderedUnitRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(TABLES.OrderedUnit.OrderedUnitGuid, typeof(Guid));
			dtXMResults.Columns.Add(TABLES.OrderedTest.OrderedTestGuid, typeof(Guid));
			dtXMResults.Columns.Add(TABLES.BloodUnit.BloodUnitGuid, typeof(Guid));
			dtXMResults.Columns.Add(TABLES.OrderedComponent.OrderedComponentGuid, typeof(Guid));	
			dtXMResults.Columns.Add(TABLES.BloodUnitTest.CorrectedResultIndicator, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.UnitStatusRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.XMComment, typeof(String));

			//Build the XMData
			DataRow drXMR = dtXMResults.NewRow();
			drXMR[TABLES.OrderableTest.OrderableTestId] = 9;		//9 = Crossmatch!
			drXMR[TABLES.OrderedUnit.OrderedUnitGuid] = orderedUnitGuid;
			drXMR[TABLES.BloodUnit.BloodUnitGuid] = bloodUnitGuid;
			drXMR[TABLES.OrderedComponent.OrderedComponentGuid] = orderedComponentGuid;	

			dtXMResults.Rows.Add(drXMR);

			BOL.BloodUnitTest.BuildXMFromBloodUnitTest(dtXMResults, Guid.Empty, orderedComponentGuid);

			Assert.IsTrue(dtXMResults.Rows[0][ARTIFICIAL.AHG].ToString().Trim() == "0");
			Assert.IsTrue((bool)dtXMResults.Rows[0][ARTIFICIAL.AHGSave] == false);
			Assert.IsTrue(((Guid)dtXMResults.Rows[0][ARTIFICIAL.AHGGuid]).ToString() == bloodUnitTestGuid.ToString());
		}

		[Test]
		public void BuildXMFromBloodUnitTest_RepeatXM_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			Guid bloodUnitGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			if (this._dtBloodUnit.Rows.Count > 0)
			{
				bloodUnitGuid = (Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			}
			else
			{
				Assert.AreEqual(bloodUnitGuid, Guid.NewGuid(), "Blood unit does not exist");
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'UnitTestUser',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'UnitTestUser',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuid = Guid.NewGuid();
			string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
			insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTest += "VALUES (";
			insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
			insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTest += "'119',";
			insertOrderedTest += "'A',";
			insertOrderedTest += "'N',";
			insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTest += "'UnitTestUser',";
			insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedUnitGuid = Guid.NewGuid();
			string insertOrderedUnit = "INSERT INTO ORDEREDUNIT (";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedTestGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.BloodUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.RecordStatusCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.DivisionCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateUser + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateFunctionId + ")";
			insertOrderedUnit += "VALUES (";
			insertOrderedUnit += "'" + orderedUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + orderedTestGuid.ToString() + "',";
			insertOrderedUnit += "'" + bloodUnitGuid.ToString() + "',";
			insertOrderedUnit += "'A',";
			insertOrderedUnit += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "'UnitTestUser',";
			insertOrderedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid bloodUnitTestGuid = Guid.NewGuid();
			string insertBloodUnitTest = "INSERT INTO BLOODUNITTEST (";
			insertBloodUnitTest += TABLES.BloodUnitTest.BloodUnitTestGuid + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.BloodUnitGuid + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.BloodTestTypeId + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.TestDate + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.TestTechId + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.TestResultId + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.EntryTechId + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.EntryMethodCode + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.OrderedTestGuid + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.OrderedUnitGuid + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.ReactivityPhaseCode + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.RecordStatusCode + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.DivisionCode + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.LastUpdateDate + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.LastUpdateUser + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.LastUpdateFunctionId + ")";
			insertBloodUnitTest += "VALUES (";
			insertBloodUnitTest += "'" + bloodUnitTestGuid.ToString() + "',";
			insertBloodUnitTest += "'" + bloodUnitGuid.ToString() + "',";
			insertBloodUnitTest += "'98',";
			insertBloodUnitTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest += "'UnitTestUser',";
			insertBloodUnitTest += "'2',";
			insertBloodUnitTest += "'UnitTestUser',";
			insertBloodUnitTest += "'M',";
			insertBloodUnitTest += "'" + orderedTestGuid.ToString() + "',";
			insertBloodUnitTest += "'" + orderedUnitGuid.ToString() + "',";
			insertBloodUnitTest += "'9',";
			insertBloodUnitTest += "'A',";
			insertBloodUnitTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertBloodUnitTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest += "'UnitTestUser',";
			insertBloodUnitTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedTest);
			UnitTestUtil.RunSQL(insertOrderedUnit);
			UnitTestUtil.RunSQL(insertBloodUnitTest);

			DataTable dtXMResults = new DataTable();

			dtXMResults.Columns.Add(TABLES.OrderableTest.OrderableTestId, typeof(int));
			dtXMResults.Columns.Add(ARTIFICIAL.IS, typeof(String));
			dtXMResults.Columns.Add(ARTIFICIAL.C37, typeof(String));
			dtXMResults.Columns.Add(ARTIFICIAL.AHG, typeof(String));
			dtXMResults.Columns.Add(ARTIFICIAL.CC, typeof(String));
			dtXMResults.Columns.Add(ARTIFICIAL.XMInterp, typeof(String));			
			dtXMResults.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.XMInterpSave, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.ISGuid, typeof(Guid));
			dtXMResults.Columns.Add(ARTIFICIAL.C37Guid, typeof(Guid));
			dtXMResults.Columns.Add(ARTIFICIAL.AHGGuid, typeof(Guid));
			dtXMResults.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtXMResults.Columns.Add(ARTIFICIAL.XMInterpGuid, typeof(Guid));
			dtXMResults.Columns.Add(ARTIFICIAL.ISRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.C37RowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.XMInterpRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.OrderedUnitRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(TABLES.OrderedUnit.OrderedUnitGuid, typeof(Guid));
			dtXMResults.Columns.Add(TABLES.OrderedTest.OrderedTestGuid, typeof(Guid));
			dtXMResults.Columns.Add(TABLES.BloodUnit.BloodUnitGuid, typeof(Guid));
			dtXMResults.Columns.Add(TABLES.OrderedComponent.OrderedComponentGuid, typeof(Guid));	
			dtXMResults.Columns.Add(TABLES.BloodUnitTest.CorrectedResultIndicator, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.UnitStatusRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.XMComment, typeof(String));

			//Build the XMData
			DataRow drXMR = dtXMResults.NewRow();
			drXMR[TABLES.OrderableTest.OrderableTestId] = 9;		//9 = Crossmatch!
			drXMR[TABLES.OrderedUnit.OrderedUnitGuid] = orderedUnitGuid;
			drXMR[TABLES.BloodUnit.BloodUnitGuid] = bloodUnitGuid;
			drXMR[TABLES.OrderedTest.OrderedTestGuid] = orderedTestGuid;	

			dtXMResults.Rows.Add(drXMR);

			BOL.BloodUnitTest.BuildXMFromBloodUnitTest(dtXMResults, orderedTestGuid, Guid.Empty);
			Assert.IsTrue(dtXMResults.Rows[0][ARTIFICIAL.IS].ToString().Trim() == "2");
			Assert.IsTrue((bool)dtXMResults.Rows[0][ARTIFICIAL.ISSave] == false);
			Assert.IsTrue(((Guid)dtXMResults.Rows[0][ARTIFICIAL.ISGuid]).ToString() == bloodUnitTestGuid.ToString());
		}

		[Test]
		public void BuildXMFromBloodUnitTest_Fail()
		{
			DataTable dtXMResults = new DataTable();

			dtXMResults.Columns.Add(TABLES.OrderableTest.OrderableTestId, typeof(int));
			dtXMResults.Columns.Add(ARTIFICIAL.IS, typeof(String));
			dtXMResults.Columns.Add(ARTIFICIAL.C37, typeof(String));
			dtXMResults.Columns.Add(ARTIFICIAL.AHG, typeof(String));
			dtXMResults.Columns.Add(ARTIFICIAL.CC, typeof(String));
			dtXMResults.Columns.Add(ARTIFICIAL.XMInterp, typeof(String));			
			dtXMResults.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.XMInterpSave, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.ISGuid, typeof(Guid));
			dtXMResults.Columns.Add(ARTIFICIAL.C37Guid, typeof(Guid));
			dtXMResults.Columns.Add(ARTIFICIAL.AHGGuid, typeof(Guid));
			dtXMResults.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtXMResults.Columns.Add(ARTIFICIAL.XMInterpGuid, typeof(Guid));
			dtXMResults.Columns.Add(ARTIFICIAL.ISRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.C37RowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.XMInterpRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.OrderedUnitRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(TABLES.OrderedUnit.OrderedUnitGuid, typeof(Guid));
			dtXMResults.Columns.Add(TABLES.OrderedTest.OrderedTestGuid, typeof(Guid));
			dtXMResults.Columns.Add(TABLES.BloodUnit.BloodUnitGuid, typeof(Guid));
			dtXMResults.Columns.Add(TABLES.OrderedComponent.OrderedComponentGuid, typeof(Guid));	
			dtXMResults.Columns.Add(TABLES.BloodUnitTest.CorrectedResultIndicator, typeof(bool));
			dtXMResults.Columns.Add(ARTIFICIAL.UnitStatusRowVersion, typeof(byte[]));
			dtXMResults.Columns.Add(ARTIFICIAL.XMComment, typeof(String));

			//Build the XMData
			DataRow drXMR = dtXMResults.NewRow();
			drXMR[TABLES.OrderableTest.OrderableTestId] = 9;		//9 = Crossmatch!
			drXMR[TABLES.OrderedUnit.OrderedUnitGuid] = Guid.NewGuid();
			drXMR[TABLES.BloodUnit.BloodUnitGuid] = Guid.NewGuid();
			drXMR[TABLES.OrderedTest.OrderedTestGuid] = Guid.NewGuid();	

			dtXMResults.Rows.Add(drXMR);
			
			BOL.BloodUnitTest.BuildXMFromBloodUnitTest(dtXMResults, Guid.Empty, Guid.Empty);

			Assert.IsTrue(dtXMResults.Rows[0][ARTIFICIAL.IS].ToString().Trim() == "");
			Assert.IsTrue((bool)dtXMResults.Rows[0][ARTIFICIAL.ISSave] == true);
		}

		[Test]
		public void InactivateAboRhConfirmationTests_Pass()
		{
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.ABORhForwardTypingUnit);
            Common.WorkloadProcessID workloadProcessId = Common.WorkloadProcessID.ABOForwardTypingUnit;     //POS

			Guid rackGuid = (Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			Guid statusGuid = Guid.NewGuid();
			Guid unitGuid = Guid.NewGuid();
			Guid bpGuid = DataCreator.GetRecordGuid("SELECT BloodProductGuid FROM BloodProduct WHERE ProductCode = '04020'");

//6/6/2005 - WAS SETTING BloodUnitStatusCode to "L" Manually here
			DataCreator.CreateBloodUnit(unitGuid, statusGuid, Guid.Empty, bpGuid, true);

			//Created a fresh unit
			BOL.BloodUnit tmpBU = new BOL.BloodUnit(unitGuid);
			
			DataTable dtAboRh = BOL.BloodUnitTest.GetEmptyAboRhConfirmationTable();
			DataRow drData = dtAboRh.NewRow();

			drData[ARTIFICIAL.Indicator] = "V";
			drData[TABLES.BloodUnit.EyeReadableUnitId] = tmpBU.EyeReadableUnitId;
			drData[TABLES.ValidAboResult.AntiA] = "P";
			drData[TABLES.ValidAboResult.AntiB] = "N";
			drData[TABLES.ValidAboResult.AntiAB] = "P";
			drData[TABLES.ValidRhResult.AntiD] = "X";
			drData[TABLES.ValidRhResult.DControl] = "X";
			drData[TABLES.ValidAboResult.AboInterp] = "A";
			drData[TABLES.ValidRhResult.RhInterp] = "X";
			drData[ARTIFICIAL.AboComment] = "SaveAboRhBloodUnitTests_Pass()";
			drData[ARTIFICIAL.RhComment] = "SaveAboRhBloodUnitTests_Pass()";
			drData[TABLES.BloodUnit.BloodUnitGuid] = tmpBU.BloodUnitGuid;
			drData[TABLES.BloodUnitStatus.RowVersion] = tmpBU.BloodUnitStatus.RowVersion;
			drData[TABLES.BloodUnitStatus.BloodUnitStatusGuid] = tmpBU.BloodUnitStatus.BloodUnitStatusGuid;

			dtAboRh.Rows.Add(drData);			

			BOL.BloodUnitTest.SaveAboRHBloodUnitTests(dtAboRh, DateTime.Now, Common.LogonUser.LogonUserName, "UnitTest", true, rackGuid, Common.UpdateFunction.UnitTests, workloadProcessId, string.Empty);

			//Created a bunch of ABO/RH Confirmation tests
			DataTable dtResults = BOL.BloodUnitTest.GetBloodUnitTests(unitGuid, this.TestDivisionCode);
			Assert.IsTrue(dtResults.Rows.Count > 0);
			
			Guid cwlGuid = (Guid)dtResults.Rows[0][TABLES.BloodUnitTest.ConfirmationWorklistUnitGuid];

			ArrayList butArray = new ArrayList();
			foreach(DataRow drTest in dtResults.Rows)
			{
				butArray.Add(new BOL.BloodUnitTest(drTest));
			}

			bool allTestsInactivated = ( butArray.Count == dtResults.Rows.Count );
			//
			BOL.BloodUnitTest.InactivateAboRHConfirmationTests( tmpBU, cwlGuid, "InactivateAboRhConfirmationTests_Pass()", Common.UpdateFunction.UnitTests, butArray, allTestsInactivated );
			
			//No return value, so all MUST be well
			//But, we check, because we're iNsAne
			//CR2083 will eventually cause this to change... Record status code SHOULD be set to E not X.
			dtResults = BOL.BloodUnitTest.GetBloodUnitTests(unitGuid, this.TestDivisionCode);
			Assert.AreEqual(0, dtResults.Rows.Count, "Records Inactivated");
			
		}

		[Test]
		[ExpectedException(typeof(BusinessObjectException))]
		public void InactivateAboRhConfirmationTests_Fail()
		{
			BOL.BloodUnitTest.InactivateAboRHConfirmationTests( new BOL.BloodUnit( Guid.NewGuid() ), Guid.NewGuid(), string.Empty, Common.UpdateFunction.UnitTests, new ArrayList(), true );
		}

		[Test]
		public void InactivateAntigenTypingTests_Pass()
		{
			//Create new Anti-C reagent to test against.
			DataTable dtReagents = Reagent.InitializeReagentsAndManufacturersTable();
			DataRow drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = Guid.NewGuid();
			drReagent[TABLES.ReagentType.ReagentTypeId] = 6; //Anti-C
			drReagent["ReagentName"] = "Test C Reagent";
			drReagent["ReceiptDate"] = DateTime.Now;
			drReagent["ReceiptTechId"] = UnitTestConfig.User_Technologist;
			drReagent["InvoiceNumber"] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "C"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent["NumberVialsReceived"] = 20;
			drReagent["NumberVialsAvailable"] = 15;
			drReagent["Comments"] = "Unit Test 1705";
			drReagent["InspectionIndicator"] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent["ReagentTypeName"] = "Anti-C";
			drReagent[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drReagent["RecordStatusCode"] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Create new Screening Cells reagent to for Pos control.
			drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = Guid.NewGuid();
			drReagent[TABLES.ReagentType.ReagentTypeId] = 63; //Screening Cells
			drReagent["ReagentName"] = "Test SC Reagent";
			drReagent["ReceiptDate"] = DateTime.Now;
			drReagent["ReceiptTechId"] = UnitTestConfig.User_Technologist;
			drReagent["InvoiceNumber"] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "SC"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent["NumberVialsReceived"] = 20;
			drReagent["NumberVialsAvailable"] = 15;
			drReagent["Comments"] = "Unit Test 1705";
			drReagent["InspectionIndicator"] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent["ReagentTypeName"] = "Screening Cells";
			drReagent[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drReagent["RecordStatusCode"] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Create new Check Cells reagent to for Neg control.
			drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = Guid.NewGuid();
			drReagent[TABLES.ReagentType.ReagentTypeId] = 56; //Check Cells
			drReagent["ReagentName"] = "Test CC Reagent";
			drReagent["ReceiptDate"] = DateTime.Now;
			drReagent["ReceiptTechId"] = UnitTestConfig.User_Technologist;
			drReagent["InvoiceNumber"] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = ARTIFICIAL.CC+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent["NumberVialsReceived"] = 20;
			drReagent["NumberVialsAvailable"] = 15;
			drReagent["Comments"] = "Unit Test 1705";
			drReagent["InspectionIndicator"] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent["ReagentTypeName"] = "Check Cells";
			drReagent[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drReagent["RecordStatusCode"] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Insert new reagents
			BOL.Reagent.InsertNewReagent(dtReagents, BOL.ReagentType.GetReagentTypes(), Common.UpdateFunction.UnitTests);
			//
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			//
			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			Guid buGuid = Guid.NewGuid();
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			Guid bloodProductGuid = (Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			DataCreator.CreateBloodUnit(buGuid, Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);
			Guid[] buGuids = new Guid[] {buGuid};
			DataTable dtUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE BloodUnitGuid = '" + buGuid.ToString() + "'");
			//
			Guid rackGuid = (Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			//
			//Now we will insert a new antisera worklist
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(Guid.NewGuid());
			tmpAW.TestingMethodCode = Common.TestingMethod.Gel;
			tmpAW.WorklistCreateDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			tmpAW.WorklistName = Environment.UserName;
			//
			DataTable tmpAWT = new DataTable();
			tmpAWT.Columns.Add("AntiseraWorklistTypingGuid", typeof(Guid));
			tmpAWT.Columns.Add(TABLES.AntiseraWorklist.AntiseraWorklistGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.ReagentGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.RackGuid,typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.ReactivityPhaseCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.Comments,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.DivisionCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.TestWithId,typeof(int));
			tmpAWT.Columns.Add("RackQCOverrideComment",typeof(string));
			tmpAWT.Columns.Add("ExpiredOverrideComment",typeof(string));
			tmpAWT.Columns.Add("PhaseOverrideComment",typeof(string));
			//
			DataRow drAWT = tmpAWT.NewRow();
			drAWT[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid] = Guid.NewGuid();
			drAWT[TABLES.AntiseraWorklist.AntiseraWorklistGuid] = tmpAW.AntiseraWorklistGuid;
			drAWT[TABLES.OrderableTest.OrderableTestId] = Convert.ToInt32(Common.OrderableTest.AGC).ToString();
			drAWT[TABLES.RackLot.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drAWT[TABLES.RackLot.RackGuid] = rackGuid;
			drAWT[TABLES.RackLot.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.AHGandCC).ToString();
			drAWT[TABLES.RackLot.Comments] = "";
			drAWT[TABLES.RackLot.DivisionCode] = this.TestDivisionCode;
			tmpAWT.Rows.Add(drAWT);
			//
			//Save the antisera worklist
			tmpAW.Save(tmpAWT,dtUnit,Environment.UserName,Common.UpdateFunction.UnitTests,new Guid[] {buGuid}, Guid.Empty, null, true);
			//
			//Now we need to load the saved antisera worklist, complete the tests and save again.
			BOL.AntiseraWorklist aw = new BOL.AntiseraWorklist(tmpAW.AntiseraWorklistGuid);
			DataTable dtAWT = BOL.AntiseraWorklist.GetAntiseraWorklistDetails(tmpAW.AntiseraWorklistGuid);
			DataTable dtUnits = BOL.AntiseraWorklist.GetAntiseraWorklistUnits(tmpAW.AntiseraWorklistGuid);
			//
			DataRow drRackLot = dtAWT.Rows[0];
			DataRow drUnit = dtUnits.Rows[0];
			DataRow drCReagent = dtReagents.Rows[0];
			//
			//Now create AGC grid table
			DataTable dtAGC = new DataTable("Phenotype");
			//
			dtAGC.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtAGC.Columns.Add(TABLES.ExceptionUnitIssue.UnitId, typeof(string));
			dtAGC.Columns.Add(TABLES.BloodProduct.ProductName, typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.IS,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.RT,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.C37,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.AHG,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.Interp, typeof(string));			
			dtAGC.Columns.Add(ARTIFICIAL.Comment, typeof(string));
			dtAGC.Columns.Add(TABLES.ValidRhResult.SystemInterp, typeof(string));
			dtAGC.Columns.Add(TABLES.BloodUnit.BloodUnitGuid, typeof(Guid));
			dtAGC.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dtAGC.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(string));
			dtAGC.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dtAGC.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.ISGuid,typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.RTGuid,typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.C37Guid,typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.AHGGuid,typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.InterpGuid, typeof(Guid));
			dtAGC.Columns.Add(ARTIFICIAL.ISRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.RTRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.C37RowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.AHGRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.CCRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.InterpRowVersion,typeof(byte[]));
			dtAGC.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtAGC.Columns.Add(ARTIFICIAL.InterpSave, typeof(bool));
			dtAGC.Columns.Add(TABLES.BloodUnitStatus.QuarantineIndicator, typeof(bool));
			dtAGC.Columns.Add(TABLES.VamcDivision.DivisionCode, typeof(string));
			dtAGC.Columns.Add(TABLES.ExceptionQc.ExceptionComment, typeof(string));
			//
			DataRow dr = dtAGC.NewRow();
			dr[ARTIFICIAL.Indicator] = "";
			dr[TABLES.ExceptionUnitIssue.UnitId] = drUnit[TABLES.BloodUnit.EyeReadableUnitId];
			dr[TABLES.BloodProduct.ProductName] = drUnit[TABLES.BloodProduct.ProductShortName];
			dr[ARTIFICIAL.AHG] = "4";
			dr[ARTIFICIAL.CC] = "4";
			dr[ARTIFICIAL.Interp] = "P";
			dr[ARTIFICIAL.Comment] = "Unit Testing";
			dr[TABLES.ValidRhResult.SystemInterp] = "P";
			dr[TABLES.BloodUnit.BloodUnitGuid] = drUnit[TABLES.BloodUnit.BloodUnitGuid];
			dr[TABLES.Reagent.ReagentGuid] = drCReagent[TABLES.Reagent.ReagentGuid];
			dr[TABLES.ReactivityPhase.ReactivityPhaseCode] = drRackLot[TABLES.ReactivityPhase.ReactivityPhaseCode];
			dr[ARTIFICIAL.IndicatorMessage] = "";
			dr[ARTIFICIAL.PartiallyCompleted] = true;
			dr[ARTIFICIAL.ISGuid] = Guid.Empty;
			dr[ARTIFICIAL.RTGuid] = Guid.Empty;
			dr[ARTIFICIAL.C37Guid] = Guid.Empty;
			dr[ARTIFICIAL.AHGGuid] = Guid.Empty;
			dr[ARTIFICIAL.CCGuid] = Guid.Empty;
			dr[ARTIFICIAL.InterpGuid] = Guid.Empty;
			dr[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.RTRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			dr[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.ISSave] = false;
			dr[ARTIFICIAL.RTSave] = false;
			dr[ARTIFICIAL.C37Save] = false;
			dr[ARTIFICIAL.AHGSave] = true;
			dr[ARTIFICIAL.CCSave] = true;
			dr[ARTIFICIAL.InterpSave] = true;
			dr[TABLES.BloodUnitStatus.QuarantineIndicator] = false;
			dr[TABLES.ExceptionQc.ExceptionComment] = DBNull.Value;
			//
			DataTable results = BOL.AntiseraWorklist.GetTestResultsForAntiseraWorklist((Guid)drUnit[TABLES.BloodUnit.BloodUnitGuid],(Guid)drRackLot["AntiseraWorklistTypingGuid"]);
			//
			DataTable testTypes = BOL.BloodTestType.GetBloodTestTypes(drRackLot[TABLES.OrderableTest.OrderableTestId].ToString());
			//
			foreach(DataRow result in results.Rows)
			{
				DataRow[] relevantTest = testTypes.Select(TABLES.BloodTestType.BloodTestTypeId+" = '" + result[TABLES.BloodTestType.BloodTestTypeId].ToString() + "'");
				if (relevantTest.Length >0)
				{
					string bloodTestType = relevantTest[0][TABLES.BloodTestType.BloodTestName].ToString();
					if (bloodTestType.IndexOf(ARTIFICIAL.AHG) > -1)
					{
						dr[ARTIFICIAL.AHGGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.AHGRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf(ARTIFICIAL.CC) > -1)
					{
						dr[ARTIFICIAL.CCGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.CCRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf(ARTIFICIAL.Interp) > -1)
					{
						dr[ARTIFICIAL.InterpGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.InterpRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
				}
			}
			//
			dtAGC.Rows.Add(dr);
			//
			//Now create control table
			//
			DataTable dtWorklistQCResults = BOL.AntiseraWorklist.GetAntiseraWorklistQCResults((Guid)drRackLot[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid]);
			//
			DataTable dtCtrl = new DataTable(ARTIFICIAL.Control);
			dtCtrl.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.Control, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.ReagentType,typeof(string));
			dtCtrl.Columns.Add(TABLES.Reagent.LotNumber, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.VialId, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.IS,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.RT,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.C37,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.AHG,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlInterp, typeof(string));			
			dtCtrl.Columns.Add(ARTIFICIAL.ControlComment, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.SystemControlInterp, typeof(string));
			dtCtrl.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlReagentGuid, typeof(Guid));
			dtCtrl.Columns.Add(TABLES.Reagent.ReagentManufacturerName, typeof(string));
			dtCtrl.Columns.Add(TABLES.Reagent.LotExpirationDate, typeof(DateTime));
			dtCtrl.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.ISGuid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.RTGuid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.C37Guid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.AHGGuid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlInterpGuid, typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.ISRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.RTRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.C37RowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.AHGRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.CCRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.InterpRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlInterpSave, typeof(bool));
			dtCtrl.Columns.Add(TABLES.VamcDivision.DivisionCode, typeof(string));
			dtCtrl.Columns.Add(TABLES.RackLot.TestWithId, typeof(int));
			dtCtrl.Columns.Add(ARTIFICIAL.OverrideComment, typeof(string));
			//
			DataRow drPos = dtCtrl.NewRow();
			drPos[ARTIFICIAL.Indicator] = "";
			drPos[ARTIFICIAL.Control] = "POS";
			drPos[ARTIFICIAL.ReagentType] = dtReagents.Rows[1][TABLES.ReagentType.ReagentTypeId];
			drPos[TABLES.Reagent.LotNumber] = dtReagents.Rows[1][TABLES.Reagent.LotNumber];
			drPos[ARTIFICIAL.VialId] = "1";
			drPos[ARTIFICIAL.AHG] = "2";
			drPos[ARTIFICIAL.CC] = "2";
			drPos[ARTIFICIAL.ControlInterp] = "P";
			drPos[ARTIFICIAL.ControlComment] = "Unit Testing";
			drPos[ARTIFICIAL.SystemControlInterp] = "P";
			drPos[TABLES.Reagent.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drPos[ARTIFICIAL.ControlReagentGuid] = dtReagents.Rows[1][TABLES.Reagent.ReagentGuid];
			drPos[TABLES.Reagent.ReagentManufacturerName] = dtReagents.Rows[1][TABLES.Reagent.ReagentManufacturerName].ToString();
			drPos[TABLES.Reagent.LotExpirationDate] = dtReagents.Rows[1][TABLES.Reagent.LotExpirationDate];
			drPos[TABLES.ReactivityPhase.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.AHGandCC).ToString();
			drPos[ARTIFICIAL.IndicatorMessage] = "";
			drPos[ARTIFICIAL.PartiallyCompleted] = true;
			drPos[ARTIFICIAL.ISGuid] = Guid.Empty;
			drPos[ARTIFICIAL.RTGuid] = Guid.Empty;
			drPos[ARTIFICIAL.C37Guid] = Guid.Empty;
			drPos[ARTIFICIAL.AHGGuid] = Guid.NewGuid();
			drPos[ARTIFICIAL.CCGuid] = Guid.NewGuid();
			drPos[ARTIFICIAL.ControlInterpGuid] = Guid.NewGuid();
			drPos[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.RTRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.ISSave] = false;
			drPos[ARTIFICIAL.RTSave] = false;
			drPos[ARTIFICIAL.C37Save] = false;
			drPos[ARTIFICIAL.AHGSave] = true;
			drPos[ARTIFICIAL.CCSave] = true;
			drPos[ARTIFICIAL.ControlInterpSave] = true;
			drPos[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drPos[TABLES.RackLot.TestWithId] = DBNull.Value;
			drPos[ARTIFICIAL.OverrideComment] = DBNull.Value;
			//
			dtCtrl.Rows.Add(drPos);
			//
			DataRow drNeg = dtCtrl.NewRow();
			drNeg[ARTIFICIAL.Indicator] = "";
			drNeg[ARTIFICIAL.Control] = "NEG";
			drNeg[ARTIFICIAL.ReagentType] = dtReagents.Rows[2][TABLES.ReagentType.ReagentTypeId];
			drNeg[TABLES.Reagent.LotNumber] = dtReagents.Rows[2][TABLES.Reagent.LotNumber];
			drNeg[ARTIFICIAL.VialId] = "0";
			drNeg[ARTIFICIAL.AHG] = "0";
			drNeg[ARTIFICIAL.CC] = "2";
			drNeg[ARTIFICIAL.ControlInterp] = "N";
			drNeg[ARTIFICIAL.ControlComment] = "Unit Testing";
			drNeg[ARTIFICIAL.SystemControlInterp] = "N";
			drNeg[TABLES.Reagent.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drNeg[ARTIFICIAL.ControlReagentGuid] = dtReagents.Rows[2][TABLES.Reagent.ReagentGuid];
			drNeg[TABLES.Reagent.ReagentManufacturerName] = dtReagents.Rows[2][TABLES.Reagent.ReagentManufacturerName];
			drNeg[TABLES.Reagent.LotExpirationDate] = dtReagents.Rows[2][TABLES.Reagent.LotExpirationDate];
			drNeg[TABLES.ReactivityPhase.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.AHGandCC).ToString();
			drNeg[ARTIFICIAL.IndicatorMessage] = "";
			drNeg[ARTIFICIAL.PartiallyCompleted] = true;
			drNeg[ARTIFICIAL.ISGuid] = Guid.Empty;
			drNeg[ARTIFICIAL.RTGuid] = Guid.Empty;
			drNeg[ARTIFICIAL.C37Guid] = Guid.Empty;
			drNeg[ARTIFICIAL.AHGGuid] = Guid.NewGuid();
			drNeg[ARTIFICIAL.CCGuid] = Guid.NewGuid();
			drNeg[ARTIFICIAL.ControlInterpGuid] = Guid.NewGuid();
			drNeg[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.RTRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.ISSave] = false;
			drNeg[ARTIFICIAL.RTSave] = false;
			drNeg[ARTIFICIAL.C37Save] = false;
			drNeg[ARTIFICIAL.AHGSave] = true;
			drNeg[ARTIFICIAL.CCSave] = true;
			drNeg[ARTIFICIAL.ControlInterpSave] = true;
			drNeg[TABLES.VamcDivision.DivisionCode] = this.TestDivisionCode;
			drNeg[TABLES.RackLot.TestWithId] = DBNull.Value;
			drNeg[ARTIFICIAL.OverrideComment] = DBNull.Value;
			//
			dtCtrl.Rows.Add(drNeg);
			//
			foreach(DataRow result in dtWorklistQCResults.Rows)
			{
				string phase = result[TABLES.RackTest.RackTestResultTypeCode].ToString().Trim();
				//
				if ((bool)result[TABLES.RackLot.ControlCellId])
				{
					drPos[ARTIFICIAL.InterpRowVersion] = result[ARTIFICIAL.RackLotRowVersion];
					drPos[ARTIFICIAL.ControlInterpGuid] = result[TABLES.RackLot.RackLotGuid];
					drPos[TABLES.RackLot.TestWithId] = result[TABLES.RackLot.TestWithId];
					//
					if (phase == ARTIFICIAL.AHG)
					{
						drPos[ARTIFICIAL.AHGGuid] = result[TABLES.RackTest.RackTestGuid];
						drPos[ARTIFICIAL.AHGRowVersion] = result[TABLES.RackTest.RowVersion];
					}
					else if (phase == ARTIFICIAL.CC)
					{
						drPos[ARTIFICIAL.CCGuid] = result[TABLES.RackTest.RackTestGuid];
						drPos[ARTIFICIAL.CCRowVersion] = result[TABLES.RackTest.RowVersion];
					}
				}
				else
				{
					drNeg[ARTIFICIAL.InterpRowVersion] = result[ARTIFICIAL.RackLotRowVersion];
					drNeg[ARTIFICIAL.ControlInterpGuid] = result[TABLES.RackLot.RackLotGuid];
					drNeg[TABLES.RackLot.TestWithId] = result[TABLES.RackLot.TestWithId];
					//
					//
					if (phase == ARTIFICIAL.AHG)
					{
						drNeg[ARTIFICIAL.AHGGuid] = result[TABLES.RackTest.RackTestGuid];
						drNeg[ARTIFICIAL.AHGRowVersion] = result[TABLES.RackTest.RowVersion];
					}
					else if (phase == ARTIFICIAL.CC)
					{
						drNeg[ARTIFICIAL.CCGuid] = result[TABLES.RackTest.RackTestGuid];
						drNeg[ARTIFICIAL.CCRowVersion] = result[TABLES.RackTest.RowVersion];
					}
				}
				//
			}
			//
			ArrayList workloadProcessIds = new ArrayList(1);
			workloadProcessIds.Add(Common.WorkloadProcessID.Unknown);
			bool res = BOL.BloodUnitTest.SaveAntigenTypingBloodUnitTests((Guid)drRackLot[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid],tmpAW,dtAGC,dtCtrl, Convert.ToInt32(Common.ReactivityPhase.AHGandCC).ToString(), Common.UpdateFunction.UC041FrmRecordPhenotypeResults, workloadProcessIds, buGuids, false);  
			//
			ArrayList buTests = BOL.BloodUnitTest.GetAntigenTypingTests(buGuid, this.TestDivisionCode);
			//
			//No return value!
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UnitAntigenPhenotypingMultipleTestPhases);
			BOL.BloodUnitTest.InactivateAntigenTypingTests(buGuid, (Guid)tmpAWT.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid], "UNIT TEST 3752", Common.UpdateFunction.UnitTests, Common.WorkloadProcessID.UnitAntigenPhenotypingMultipleTestPhases, buTests);
			Assert.IsTrue(res);
		}

		[Test]
		[ExpectedException(typeof(BusinessObjectException))]
		public void InactivateAntigenTypingTests_Fail()
		{
			BOL.BloodUnitTest.InactivateAntigenTypingTests(Guid.NewGuid(), Guid.NewGuid(), string.Empty, Common.UpdateFunction.UnitTests, Common.WorkloadProcessID.Unknown, new ArrayList());
		}

		[Test]
		public void InvalidateCrossmatchTestResults_Pass()
		{
			DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Patient ORDER BY LastUpdateDate DESC");
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			
			Guid bloodUnitGuid = Guid.NewGuid();
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			Guid bloodProductGuid = (Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			DataCreator.CreateBloodUnit(bloodUnitGuid, Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			Guid patientTreatmentGuid = Guid.NewGuid();
			DataCreator.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			DataCreator.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid orderedComponentGuid = Guid.NewGuid();
			DataCreator.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid orderedUnitGuid = Guid.NewGuid();
			DataCreator.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			DataCreator.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			DataCreator.InsertBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");

//			this.UpdateBloodUnitStatus(bloodUnitGuid, Common.UnitStatusCode.CrossmatchedAssigned);
			//
			ArrayList selectedTests = BOL.OrderedComponent.GetBloodUnitTestResultsForOrderedComponent(orderedComponentGuid,bloodUnitGuid);
			//
			BOL.OrderedUnit.ReleaseOrderedUnits(new BOL.BloodUnit(bloodUnitGuid,bloodProductGuid),"Unit Test 4119",DateTime.Now,Environment.UserName,Common.UpdateFunction.UnitTests,null);
			//
			BOL.OrderedUnit orderedUnit = new BOL.OrderedUnit(orderedUnitGuid, this.TestDivisionCode, false);
			//
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UnitAntigenPhenotypingMultipleTestPhases);
			ArrayList workloadProcessIds = new ArrayList(1);
			workloadProcessIds.Add(Common.WorkloadProcessID.UnitAntigenPhenotypingMultipleTestPhases);
			workloadProcessIds.Add(Common.WorkloadProcessID.UnitAntigenPhenotypingMultipleTestPhases);
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UnitAntigenPhenotypingMultipleTestPhases);

			bool result = BOL.BloodUnitTest.InvalidateCrossmatchTestResults((int)Common.OrderableTest.XM, selectedTests, orderedUnit, "Unit Test 4119", true, Guid.NewGuid(), workloadProcessIds, Common.UpdateFunction.UnitTests);
			Assert.IsTrue(result);
		}

		[Test]
		public void InvalidateCrossmatchTestResultsRepeatXMatch_Pass()
		{
			DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Patient ORDER BY LastUpdateDate DESC");
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			Guid bloodUnitGuid = Guid.NewGuid();
			Guid bloodProductGuid = (Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			Guid patientTreatmentGuid = Guid.NewGuid();
			DataCreator.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			DataCreator.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid patientSpecimenGuid = Guid.NewGuid();
			DataCreator.InsertPatientSpecimen(patientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			DataCreator.InsertOrderedTest(orderedTestGuid, patientOrderGuid, patientSpecimenGuid, Common.OrderableTest.RepeatXM);

			Guid orderedUnitGuid = Guid.NewGuid();
			DataCreator.InsertOrderedUnitForRepeatXMatch(orderedUnitGuid, orderedTestGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			DataCreator.InsertBloodUnitTestForRepeatXMatch(bloodUnitTestGuid1, bloodUnitGuid, orderedTestGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			DataCreator.InsertBloodUnitTestForRepeatXMatch(bloodUnitTestGuid2, bloodUnitGuid, orderedTestGuid, orderedUnitGuid, 102, "C");

			//			this.UpdateBloodUnitStatus(bloodUnitGuid, Common.UnitStatusCode.CrossmatchedAssigned);
			//
			//ArrayList selectedTests = BOL.OrderedComponent.GetBloodUnitTestResultsForOrderedComponent(orderedComponentGuid,bloodUnitGuid);
			ArrayList selectedTests = BOL.OrderedTest.GetBloodUnitTestResultsForOrderedTest(orderedTestGuid,bloodUnitGuid);
			//
			BOL.OrderedUnit.ReleaseOrderedUnits(new BOL.BloodUnit(bloodUnitGuid,bloodProductGuid),"Unit Test 4119",DateTime.Now,Environment.UserName,Common.UpdateFunction.UnitTests,null);
			//
			BOL.OrderedUnit orderedUnit = new BOL.OrderedUnit(orderedUnitGuid, this.TestDivisionCode, false);
			//
			orderedUnit.ReleaseTechId = "";
			orderedUnit.ReleaseDate = DateTime.MinValue;
			bool result = BOL.BloodUnitTest.InvalidateCrossmatchTestResults((int)Common.OrderableTest.RepeatXM, selectedTests, orderedUnit, "Unit Test 4119", true,Guid.NewGuid(),  new ArrayList(), Common.UpdateFunction.UnitTests);
			Assert.IsTrue(result);
		}

		[Test]
		[ExpectedException(typeof(BusinessObjectException))]
		public void InvalidateCrossmatchTestResults_Fail()
		{
			BOL.BloodUnitTest.InvalidateCrossmatchTestResults((int)Common.OrderableTest.XM, new ArrayList(), new BOL.OrderedUnit(), string.Empty, false, Guid.NewGuid(),  new ArrayList(), Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void AutoInstrumentName_Pass()
		{
			string tstValue = DateTime.Now.ToString();
			
			this._tstBUT.AutoInstrumentName = tstValue;

			Assert.AreEqual(this._tstBUT.AutoInstrumentName, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AutoInstrumentName_Fail()
		{
		}

		[Test]
		public void OrderedUnitGuid_Pass()
		{
			Guid tstValue = Guid.NewGuid();
			
			this._tstBUT.OrderedUnitGuid = tstValue;

			Assert.AreEqual(this._tstBUT.OrderedUnitGuid, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderedUnitGuid_Fail()
		{
		}

		[Test]
		public void InvalidatePartiallyCompletedCrossmatch_Pass()
		{
			DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Patient ORDER BY LastUpdateDate DESC");
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			Guid bloodUnitGuid = Guid.NewGuid();
			Guid bloodProductGuid = (Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			Guid patientTreatmentGuid = Guid.NewGuid();
			DataCreator.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			DataCreator.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid orderedComponentGuid = Guid.NewGuid();
			DataCreator.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid patientSpecimenGuid = Guid.NewGuid();
			DataCreator.InsertPatientSpecimen(patientSpecimenGuid, patientGuid,false);

			Guid orderedTestGuid = Guid.NewGuid();
			DataCreator.InsertOrderedTest(orderedTestGuid, patientOrderGuid, patientSpecimenGuid, Common.OrderableTest.RepeatXM);

			Guid orderedUnitGuid = Guid.NewGuid();
			DataCreator.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid repeatOrderedUnitGuid = Guid.NewGuid();
			BOL_BloodUnitTest.InsertRepeatOrderedUnit(repeatOrderedUnitGuid, Guid.Empty, orderedTestGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			DataCreator.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid3 = Guid.NewGuid();
			DataCreator.InsertBloodUnitTest(bloodUnitTestGuid3, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			DataRow drComponent = UnitTestUtil.RunSQLGetDataRow("SELECT * FROM OrderedComponent WHERE OrderedComponentGuid = '"+orderedComponentGuid.ToString()+"'");
			BOL.OrderedComponent orderedComponent = new BOL.OrderedComponent(drComponent);
			DataTable dtComponentTest = UnitTestUtil.RunSQLGetDataTable("SELECT InactivateDate, InactivateUser, TestComments, BloodUnitTestGuid,LastUpdateUser,LastUpdateFunctionId,RowVersion,LastUpdateDate FROM BloodUnitTest WHERE BloodUnitTestGuid = '"+bloodUnitTestGuid1.ToString()+"'");
			
			BOL.OrderedTest orderedTest = new BOL.OrderedTest(orderedTestGuid, patientOrderGuid);
			DataTable dtTest = UnitTestUtil.RunSQLGetDataTable("SELECT InactivateDate, InactivateUser, TestComments, BloodUnitTestGuid,LastUpdateUser,LastUpdateFunctionId,RowVersion,LastUpdateDate FROM BloodUnitTest WHERE BloodUnitTestGuid = '"+bloodUnitTestGuid3.ToString()+"'");

			dtComponentTest.Rows[0][TABLES.BloodUnitTest.InactivateDate] = System.DateTime.Now;
			dtComponentTest.Rows[0][TABLES.BloodUnitTest.InactivateUser] = Common.LogonUser.LogonUserName;
			dtComponentTest.Rows[0][TABLES.BloodUnitTest.TestComments] = "BOL.UnitTests.InvalidatePartiallyCompletedCrossmatch_Pass()";

			Assert.AreEqual(true, BOL.BloodUnitTest.InvalidatePartiallyCompletedCrossmatch(dtComponentTest, null, orderedComponent, Common.UpdateFunction.UnitTests), "XMReturnValue");

			dtTest.Rows[0][TABLES.BloodUnitTest.InactivateDate] = System.DateTime.Now;
			dtTest.Rows[0][TABLES.BloodUnitTest.InactivateUser] = Common.LogonUser.LogonUserName;
			dtTest.Rows[0][TABLES.BloodUnitTest.TestComments] = "BOL.UnitTests.InvalidatePartiallyCompletedCrossmatch_Pass()";

			Assert.AreEqual(true, BOL.BloodUnitTest.InvalidatePartiallyCompletedCrossmatch(dtTest, orderedTest, null, Common.UpdateFunction.UnitTests), "RepeatXMReturnValue");

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InvalidatePartiallyCompletedCrossmatch_Fail()
		{
		}

		[Test]
		public void GetTestResultsForXM_OrderedComponent_Pass()
		{
			DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Patient ORDER BY LastUpdateDate DESC");
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			Guid bloodUnitGuid = Guid.NewGuid();
			Guid bloodProductGuid = (Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			Guid patientTreatmentGuid = Guid.NewGuid();
			DataCreator.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			DataCreator.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid orderedComponentGuid = Guid.NewGuid();
			DataCreator.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid orderedUnitGuid = Guid.NewGuid();
			DataCreator.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			DataCreator.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			DataCreator.InsertBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");
			//
			DataTable dtResults = BOL.BloodUnitTest.GetTestResultsForXM(Guid.Empty,orderedComponentGuid);
			Assert.AreEqual(2,dtResults.Rows.Count,"Rows.Count");
		}

		[Test]
		public void GetTestResultsForXM_OrderedTest_Pass()
		{
			DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Patient ORDER BY LastUpdateDate DESC");
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			Guid bloodUnitGuid = Guid.NewGuid();
			Guid bloodProductGuid = (Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			Guid patientTreatmentGuid = Guid.NewGuid();
			DataCreator.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			DataCreator.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid orderedComponentGuid = Guid.NewGuid();
			DataCreator.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid patientSpecimenGuid = Guid.NewGuid();
			DataCreator.InsertPatientSpecimen(patientSpecimenGuid, patientGuid,false);

			Guid orderedTestGuid = Guid.NewGuid();
			DataCreator.InsertOrderedTest(orderedTestGuid, patientOrderGuid, patientSpecimenGuid, Common.OrderableTest.RepeatXM);

			Guid orderedUnitGuid = Guid.NewGuid();
			DataCreator.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid repeatOrderedUnitGuid = Guid.NewGuid();
			BOL_BloodUnitTest.InsertRepeatOrderedUnit(repeatOrderedUnitGuid, Guid.Empty, orderedTestGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid3 = Guid.NewGuid();
			DataCreator.InsertBloodUnitTest(bloodUnitTestGuid3, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid4 = Guid.NewGuid();
			DataCreator.InsertBloodUnitTest(bloodUnitTestGuid4, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			BOL_BloodUnitTest.InsertRepeatBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, Guid.Empty, orderedTestGuid, repeatOrderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			BOL_BloodUnitTest.InsertRepeatBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, Guid.Empty, orderedTestGuid, repeatOrderedUnitGuid, 102, "C");
			//
			DataTable dtResults = BOL.BloodUnitTest.GetTestResultsForXM(orderedTestGuid, Guid.Empty);
			Assert.AreEqual(2,dtResults.Rows.Count,"Rows.Count");
		}

		[Test]
		public void GetTestResultsForXM_Fail()
		{
			DataTable dtResults = BOL.BloodUnitTest.GetTestResultsForXM(Guid.Empty, Guid.Empty);
			Assert.AreEqual(0,dtResults.Rows.Count,"Rows.Count");
		}

		public static void InsertRepeatOrderedUnit(Guid orderedUnitGuid, Guid orderedComponentGuid, Guid orderedTestGuid, Guid bloodUnitGuid)
		{
			string insertOrderedUnit = "INSERT INTO ORDEREDUNIT (";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedComponentGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.OrderedTestGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.BloodUnitGuid + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchRequiredIndicator + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchResultCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.CrossmatchTechId + ",";
			insertOrderedUnit += TABLES.OrderedUnit.RecordStatusCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.DivisionCode + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateDate + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateUser + ",";
			insertOrderedUnit += TABLES.OrderedUnit.LastUpdateFunctionId + ")";
			insertOrderedUnit += "VALUES (";
			insertOrderedUnit += "'" + orderedUnitGuid.ToString() + "',";
			if (orderedComponentGuid == Guid.Empty)
			{
				insertOrderedUnit += "null,";
			}
			else
			{
				insertOrderedUnit += "'" + orderedComponentGuid.ToString() + "',";
			}
			if (orderedTestGuid == Guid.Empty)
			{
				insertOrderedUnit += "null,";
			}
			else
			{
				insertOrderedUnit += "'" + orderedTestGuid.ToString() + "',";
			}
			insertOrderedUnit += "'" + bloodUnitGuid.ToString() + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "1,";
			insertOrderedUnit += "'C',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'A',";
			insertOrderedUnit += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedUnit += "'" + Environment.UserName + "',";
			insertOrderedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			//
			UnitTestUtil.RunSQL(insertOrderedUnit);
		}

		public static void InsertRepeatBloodUnitTest(Guid bloodUnitTestGuid, Guid bloodUnitGuid, Guid orderedComponentGuid, Guid orderedTestGuid, Guid orderedUnitGuid, int bloodTestTypeId, string testResultId)
		{
			string insertBloodUnitTest = "INSERT INTO BLOODUNITTEST (";
			insertBloodUnitTest += TABLES.BloodUnitTest.BloodUnitTestGuid + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.BloodUnitGuid + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.BloodTestTypeId + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.TestDate + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.TestTechId + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.TestResultId + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.EntryTechId + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.EntryMethodCode + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.OrderedComponentGuid + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.OrderedTestGuid + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.OrderedUnitGuid + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.ReactivityPhaseCode + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.RecordStatusCode + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.DivisionCode + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.LastUpdateDate + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.LastUpdateUser + ",";
			insertBloodUnitTest += TABLES.BloodUnitTest.LastUpdateFunctionId + ")";
			insertBloodUnitTest += "VALUES (";
			insertBloodUnitTest += "'" + bloodUnitTestGuid.ToString() + "',";
			insertBloodUnitTest += "'" + bloodUnitGuid.ToString() + "',";
			insertBloodUnitTest += bloodTestTypeId.ToString() + ",";
			insertBloodUnitTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest += "'" + Environment.UserName + "',";
			insertBloodUnitTest += "'" + testResultId + "',";
			insertBloodUnitTest += "'" + Environment.UserName + "',";
			insertBloodUnitTest += "'M',";
			if (orderedComponentGuid != Guid.Empty)
			{
				insertBloodUnitTest += "'" + orderedComponentGuid.ToString() + "',";
			}
			else
			{
				insertBloodUnitTest += "null,";
			}
			if (orderedTestGuid != Guid.Empty)
			{
				insertBloodUnitTest += "'" + orderedTestGuid.ToString() + "',";
			}
			else
			{
				insertBloodUnitTest += "null,";
			}
			if (orderedUnitGuid != Guid.Empty)
			{
				insertBloodUnitTest += "'" + orderedUnitGuid.ToString() + "',";
			}
			else
			{
				insertBloodUnitTest += "null,";
			}
			insertBloodUnitTest += "'2',";
			insertBloodUnitTest += "'A',";
			insertBloodUnitTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertBloodUnitTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertBloodUnitTest += "'" + Environment.UserName + "',";
			insertBloodUnitTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			//
			UnitTestUtil.RunSQL(insertBloodUnitTest);
		}

	}
}
#endif



